% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McNemar_exact_unconditional_test_paired_2x2.R
\name{McNemar_exact_unconditional_test_paired_2x2}
\alias{McNemar_exact_unconditional_test_paired_2x2}
\title{The McNemar exact unconditional test}
\usage{
McNemar_exact_unconditional_test_paired_2x2(
  n,
  gamma = 1e-04,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed table (a 2x2 matrix)}

\item{gamma}{parameter for the Berger and Boos procedure (default=0.0001; gamma=0: no adj)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
The T version of the test statistic (not the Z one)
}
\description{
The McNemar exact unconditional test

Described in Chapter 8 "The Paired 2x2 Table"
}
\note{
Somewhat crude code with maximization over a simple partition of the
nuisance parameter space into 'num_pi_values' equally spaced values
(default: 1000). The number may be changed below. This method could be
improved with a better algorithm for the maximization; however, it works
well for most purposes. Try \code{showplot=1} to get an indication of
the precision. A refinement of the maximization can be done with a manual
restriction of the parameter space.
}
\examples{
# Airway hyper-responsiveness before and after stem cell transplantation
# (Bentur et al., 2009)
n <- rbind(c(1, 1), c(7, 12))
McNemar_exact_unconditional_test_paired_2x2(n)

\dontrun{
# Complete response before and after consolidation therapy
# (Cavo et al., 2012)
n <- rbind(c(59, 6), c(16, 80))
McNemar_exact_unconditional_test_paired_2x2(n)
}

# Floppy eyelid syndrome vs obstructive sleep apnea (Ezra et al., 2010)
n <- rbind(c(7, 25), c(2, 68))
McNemar_exact_unconditional_test_paired_2x2(n)
}
