% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPlot.R
\name{contourPlot}
\alias{contourPlot}
\title{Plot a contour map}
\usage{
contourPlot(
  x,
  y,
  z,
  nx = length(unique(x)),
  main = NULL,
  axis = TRUE,
  legend = TRUE,
  xlab = "",
  ylab = "",
  col = NULL,
  breaks = NULL,
  nlevels = 10
)
}
\arguments{
\item{x}{a vector of x co-ordinates}

\item{y}{a vector of y co-ordinates}

\item{z}{a vector of z co-ordinates representing the height of the contours}

\item{nx}{The number of pixels that will be in final plot. default is length(unique(x))}

\item{main}{Title of plot}

\item{axis}{logical if TRUE displays the axes of the plot}

\item{legend}{logical if TRUE displays the legend}

\item{xlab}{label on x axis}

\item{ylab}{label on y axis}

\item{col}{list of colors to be applied to contours.}

\item{breaks}{list of values indicating the contour ranges}

\item{nlevels}{useful if breaks and col are left as null. Sets the number of levels of the contours to be plotted}
}
\value{
A contour plot (similar to those in base, additional elements can be added using lines, points functions etc.
}
\description{
Takes x,y,z co-ordinates and plots them on a contour map. Smoothing and interpolation is done by means of fitting a spline to the data.
}
\examples{
x <- Volcontour$x
y <- Volcontour$y
z <- Volcontour$z

contourPlot(x = x, y = y, z = z)

# A smoother contour
contourPlot(x = x, y = y, z = z, nx = 500)

# Changing breaks and colours
breaks = pretty(c(min(z),max(z)))
col = brewer.pal(n = length(breaks)-1, "Blues")
contourPlot(x = x, y = y, z = z, nx = 500, breaks = breaks, col = col)

# add lines
lines(circle(0, 0, 26.5))
}
