% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unordered.R
\name{as.unordered}
\alias{as.unordered}
\title{Convert to unordered factor}
\usage{
as.unordered(x)
}
\arguments{
\item{x}{Object to convert to unordered factor}
}
\value{
\code{x} as an unordered factor
}
\description{
Unordered analogue of base R's \code{as.ordered}. Will convert \code{x} to an unordered
factor; unlike \code{as.factor()}, this will convert ordered factors to unordered
factors.
}
\examples{

# Convert an ordered factor to unordered
as.unordered(gl(5,1,ordered = TRUE))

# If level order is pre-specified differently from default alphabetical order
# then the ordering will be retained
as.unordered(ordered(c("a", "b", "c"), levels = c("c", "a", "b")))

# Otherwise the vector will be converted to an unordered factor with levels
# in the default alphabetical order
as.unordered(c("c", "a", "b"))

# Note that coercing integer values will sort the values to use as the levels
as.unordered(4:1)
}
\seealso{
\code{\link[=as.factor]{as.factor()}}
}
