% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convoSPAT_summplot.R
\name{mc_N}
\alias{mc_N}
\title{Calculate local sample sizes.}
\usage{
mc_N(coords, mc.locations, fit.radius)
}
\arguments{
\item{coords}{A matrix of observation locations.}

\item{mc.locations}{A matrix of the mixture component locations to
use in the model fitting.}

\item{fit.radius}{Scalar; defines the fitting radius for local likelihood
estimation.}
}
\value{
A vector \code{mc.N.fit}, which summarizes the number of
observation locations in \code{coords} that fall within the fit radius
for each mixture component location.
}
\description{
\code{mc_N} calculates the number of observations (sample size) that
fall within a certain fit radius for each mixture component location.
}
\examples{
\dontrun{
mc_N( coords = simdata$sim.locations, mc.locations = simdata$mc.locations,
fit.radius = 1 )
}
}

