/*
  Copyright (C) 2012 Marius Hofert, Ivan Kojadinovic, Martin Maechler, and Jun Yan

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, see <http://www.gnu.org/licenses/>.
*/


/* #include <gsl/gsl_sf_debye.h> */
/* #include <gsl/gsl_errno.h> */

/* function names generated by removing  "gsl_sf" from the beginning
   of the name and _e from the end.  Thus gsl_sf_debye_1_e  goes to
   debye_1. */

/*#include <math.h> */

#include "cop_gsl.h"
#include "copula.h"

// "_C": nameclash - already have R level 'debye_1'
void debye_1_C(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
/* 	gsl_set_error_handler_off(); */

	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_debye_1_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}

void debye_2(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
/* 	gsl_set_error_handler_off(); */

	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_debye_2_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}

void debye_3(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
/* 	gsl_set_error_handler_off(); */

	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_debye_3_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}

void debye_4(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
/* 	gsl_set_error_handler_off(); */

	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_debye_4_e(x[i] , &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}
