/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.data.simple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.corehunter.data.GenotypeData;
import org.corehunter.data.GenotypeDataFormat;
import org.corehunter.data.simple.SimpleBiAllelicGenotypeData;
import org.corehunter.util.StringUtils;
import uno.informatics.common.io.IOUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.DataPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class SimpleGenotypeData
extends DataPojo
implements GenotypeData {
    private static final double SUM_TO_ONE_PRECISION = 0.01000001;
    private static final String NAMES_HEADER = "NAME";
    private static final String ALLELE_NAMES_HEADER = "ALLELE";
    private static final String IDENTIFIERS_HEADER = "ID";
    private final Double[][][] alleleFrequencies;
    private final int numberOfMarkers;
    private final int[] numberOfAllelesForMarker;
    private final int totalNumberAlleles;
    private final String[] markerNames;
    private final String[][] alleleNames;

    public SimpleGenotypeData(SimpleEntity[] itemHeaders, String[] markerNames, String[][] alleleNames, Double[][][] alleleFrequencies) {
        this("Multiallelic marker data", itemHeaders, markerNames, alleleNames, alleleFrequencies);
    }

    public SimpleGenotypeData(String datasetName, SimpleEntity[] itemHeaders, String[] markerNames, String[][] alleleNames, Double[][][] alleleFrequencies) {
        super(datasetName, itemHeaders);
        int j;
        int i;
        int n = alleleFrequencies.length;
        int m = -1;
        int[] a = null;
        for (i = 0; i < n; ++i) {
            Double[][] indFreqs = alleleFrequencies[i];
            if (indFreqs == null) {
                throw new IllegalArgumentException("Allele frequencies not defined for individual " + i);
            }
            if (m == -1) {
                m = indFreqs.length;
                a = new int[m];
                Arrays.fill(a, -1);
            } else if (indFreqs.length != m) {
                throw new IllegalArgumentException("All individuals should have same number of markers.");
            }
            for (int j2 = 0; j2 < m; ++j2) {
                Double[] alleleFreqs = indFreqs[j2];
                if (alleleFreqs == null) {
                    throw new IllegalArgumentException(String.format("Allele frequencies not defined for individual %d at marker %d.", i, j2));
                }
                if (a[j2] == -1) {
                    a[j2] = alleleFreqs.length;
                } else if (alleleFreqs.length != a[j2]) {
                    throw new IllegalArgumentException("Number of alleles per marker should be consistent across all individuals.");
                }
                if (Arrays.stream(alleleFreqs).filter(Objects::nonNull).anyMatch(f -> f < 0.0)) {
                    throw new IllegalArgumentException("All frequencies should be positive.");
                }
                double sum = Arrays.stream(alleleFreqs).filter(Objects::nonNull).mapToDouble(Double::doubleValue).sum();
                if (sum > 1.0) {
                    throw new IllegalArgumentException("Allele frequency sum per marker should not exceed one.");
                }
                if (!Arrays.stream(alleleFreqs).noneMatch(Objects::isNull)) continue;
                if (1.0 - sum > 0.01000001) {
                    throw new IllegalArgumentException("Allele frequencies for marker should sum to one.");
                }
                int k = 0;
                while (k < alleleFreqs.length) {
                    Double[] doubleArray = alleleFreqs;
                    int n2 = k++;
                    Double.valueOf(doubleArray[n2] / sum);
                }
            }
        }
        this.numberOfMarkers = m;
        this.numberOfAllelesForMarker = a;
        this.totalNumberAlleles = Arrays.stream(this.numberOfAllelesForMarker).sum();
        this.alleleFrequencies = new Double[n][m][];
        for (i = 0; i < n; ++i) {
            for (int j3 = 0; j3 < m; ++j3) {
                this.alleleFrequencies[i][j3] = Arrays.copyOf(alleleFrequencies[i][j3], this.numberOfAllelesForMarker[j3]);
            }
        }
        if (markerNames == null) {
            this.markerNames = new String[m];
        } else {
            if (markerNames.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of marker names provided. Expected: %d, actual: %d.", m, markerNames.length));
            }
            this.markerNames = Arrays.copyOf(markerNames, m);
        }
        this.alleleNames = new String[m][];
        if (alleleNames == null) {
            for (j = 0; j < m; ++j) {
                this.alleleNames[j] = new String[this.numberOfAllelesForMarker[j]];
            }
        } else {
            if (alleleNames.length != m) {
                throw new IllegalArgumentException(String.format("Incorrect number of marker-allele names provided. Expected: %d, actual: %d.", m, alleleNames.length));
            }
            for (j = 0; j < m; ++j) {
                if (alleleNames[j] == null) {
                    this.alleleNames[j] = new String[this.numberOfAllelesForMarker[j]];
                    continue;
                }
                if (alleleNames[j].length != this.numberOfAllelesForMarker[j]) {
                    throw new IllegalArgumentException(String.format("Incorrect number of allele names provided for marker %d. Expected: %d, actual: %d.", j, this.numberOfAllelesForMarker[j], alleleNames[j].length));
                }
                this.alleleNames[j] = Arrays.copyOf(alleleNames[j], this.numberOfAllelesForMarker[j]);
            }
        }
    }

    @Override
    public int getNumberOfMarkers() {
        return this.numberOfMarkers;
    }

    @Override
    public int getNumberOfAlleles(int markerIndex) {
        return this.numberOfAllelesForMarker[markerIndex];
    }

    @Override
    public String getMarkerName(int markerIndex) {
        return this.markerNames[markerIndex];
    }

    @Override
    public int getTotalNumberOfAlleles() {
        return this.totalNumberAlleles;
    }

    @Override
    public String getAlleleName(int markerIndex, int alleleIndex) {
        return this.alleleNames[markerIndex][alleleIndex];
    }

    @Override
    public Double getAlleleFrequency(int id, int markerIndex, int alleleIndex) {
        return this.alleleFrequencies[id][markerIndex][alleleIndex];
    }

    @Override
    public boolean hasMissingValues(int id, int markerIndex) {
        return Arrays.stream(this.alleleFrequencies[id][markerIndex]).anyMatch(Objects::isNull);
    }

    public static GenotypeData readData(Path filePath, FileType type) throws IOException {
        return SimpleGenotypeData.readData(filePath, type, GenotypeDataFormat.FREQUENCY);
    }

    public static GenotypeData readData(Path filePath, FileType type, GenotypeDataFormat format) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException("Format not defined.");
        }
        switch (format) {
            case DEFAULT: {
                return SimpleGenotypeData.readDefaultData(filePath, type);
            }
            case FREQUENCY: {
                return SimpleGenotypeData.readFrequencyData(filePath, type);
            }
            case BIPARENTAL: {
                return SimpleBiAllelicGenotypeData.readData(filePath, type);
            }
        }
        throw new IllegalArgumentException("Unsupported format : " + (Object)((Object)format));
    }

    private static SimpleGenotypeData readFrequencyData(Path filePath, FileType type) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        Throwable throwable = null;
        try (RowReader reader = IOUtilities.createRowReader(filePath, type, 16, 8);){
            LinkedHashMap<String, Integer> markers;
            int numCols;
            int numDataCols;
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            reader.nextRow();
            String[] markerNamesRow = reader.getRowCellsAsStringArray();
            if (markerNamesRow.length < 1 || !Objects.equals(markerNamesRow[0], IDENTIFIERS_HEADER)) {
                throw new IOException("Missing header row/column ID.");
            }
            boolean withNames = markerNamesRow.length >= 2 && Objects.equals(markerNamesRow[1], NAMES_HEADER);
            int numHeaderCols = 1;
            if (withNames) {
                ++numHeaderCols;
            }
            if ((numDataCols = (numCols = markerNamesRow.length) - numHeaderCols) == 0) {
                throw new IOException("No data columns.");
            }
            markerNamesRow = (String[])Arrays.stream(markerNamesRow).skip(numHeaderCols).map(StringUtils::unquote).toArray(String[]::new);
            try {
                markers = SimpleGenotypeData.inferMarkerNames(markerNamesRow);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
            String[] markerNames = ((HashMap)markers).keySet().toArray(new String[0]);
            Integer[] alleleCounts = ((HashMap)markers).values().toArray(new Integer[0]);
            int numMarkers = markers.size();
            String[][] alleleNames = null;
            ArrayList<String> itemNames = new ArrayList<String>();
            ArrayList<String> itemIdentifiers = new ArrayList<String>();
            ArrayList<Double[][]> alleleFreqs = new ArrayList<Double[][]>();
            int r = 1;
            while (reader.nextRow()) {
                String[] row = reader.getRowCellsAsStringArray();
                if (row.length != numCols) {
                    throw new IOException(String.format("Incorrect number of columns at row %d. Expected: %d, actual: %d.", r, numCols, row.length));
                }
                if (Objects.equals(row[0], ALLELE_NAMES_HEADER)) {
                    if (r != 1) {
                        throw new IOException("Allele names header should be the second row in the file.");
                    }
                    int aglob = numHeaderCols;
                    alleleNames = new String[numMarkers][];
                    for (int m = 0; m < numMarkers; ++m) {
                        alleleNames[m] = new String[alleleCounts[m].intValue()];
                        for (int a = 0; a < alleleNames[m].length; ++a) {
                            alleleNames[m][a] = StringUtils.unquote(row[aglob]);
                            ++aglob;
                        }
                    }
                } else {
                    itemIdentifiers.add(StringUtils.unquote(row[0]));
                    if (withNames) {
                        itemNames.add(StringUtils.unquote(row[1]));
                    }
                    Double[][] freqsPerMarker = new Double[numMarkers][];
                    int fglob = numHeaderCols;
                    for (int m = 0; m < numMarkers; ++m) {
                        freqsPerMarker[m] = new Double[alleleCounts[m].intValue()];
                        for (int f = 0; f < freqsPerMarker[m].length; ++f) {
                            Double freq;
                            try {
                                freq = row[fglob] == null ? null : Double.valueOf(Double.parseDouble(row[fglob]));
                            }
                            catch (NumberFormatException ex) {
                                throw new IOException(String.format("Invalid frequency at row %d, column %d. Expected double value, got: \"%s\".", r, fglob, row[fglob]), ex);
                            }
                            freqsPerMarker[m][f] = freq;
                            ++fglob;
                        }
                    }
                    alleleFreqs.add(freqsPerMarker);
                }
                ++r;
            }
            int n = alleleFreqs.size();
            if (n == 0) {
                throw new IOException("No data rows.");
            }
            SimpleEntity[] headers = new SimpleEntity[n];
            for (int i = 0; i < n; ++i) {
                String identifier = (String)itemIdentifiers.get(i);
                String name = withNames ? (String)itemNames.get(i) : (String)itemIdentifiers.get(i);
                headers[i] = name != null ? new SimpleEntityPojo(identifier, name) : new SimpleEntityPojo(identifier);
            }
            Double[][][] alleleFreqsArray = (Double[][][])alleleFreqs.stream().toArray(k -> new Double[k][][]);
            try {
                SimpleGenotypeData identifier = new SimpleGenotypeData(filePath.getFileName().toString(), headers, markerNames, alleleNames, alleleFreqsArray);
                return identifier;
            }
            catch (IllegalArgumentException ex) {
                try {
                    throw new IOException(ex.getMessage());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static SimpleGenotypeData readDefaultData(Path filePath, FileType type) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        Throwable throwable = null;
        try (RowReader reader = IOUtilities.createRowReader(filePath, type, 16);){
            LinkedHashMap<String, Integer> markers;
            int n;
            if (reader == null || !reader.ready()) {
                throw new IOException("Can not create reader for file " + filePath + ". File may be empty.");
            }
            if (!reader.hasNextRow()) {
                throw new IOException("File is empty.");
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (reader.nextRow()) {
                rows.add(reader.getRowCellsAsStringArray());
            }
            if (rows.isEmpty()) {
                throw new IOException("File is empty.");
            }
            int numCols = rows.stream().mapToInt(row -> ((String[])row).length).max().getAsInt();
            for (int r = 0; r < rows.size(); ++r) {
                String[] row2 = (String[])rows.get(r);
                if ((row2 = StringUtils.unquote(row2)).length < numCols) {
                    row2 = Arrays.copyOf(row2, numCols);
                }
                rows.set(r, row2);
            }
            if (numCols < 1 || !Objects.equals(((String[])rows.get(0))[0], IDENTIFIERS_HEADER)) {
                throw new IOException("Missing header row/column ID.");
            }
            boolean withNames = numCols >= 2 && Objects.equals(((String[])rows.get(0))[1], NAMES_HEADER);
            int numHeaderCols = 1;
            if (withNames) {
                ++numHeaderCols;
            }
            if ((n = rows.size() - 1) == 0) {
                throw new IOException("No data rows.");
            }
            int numDataCols = numCols - numHeaderCols;
            if (numDataCols == 0) {
                throw new IOException("No data columns.");
            }
            String[] headerRow = (String[])rows.get(0);
            String[] dataColumnNames = Arrays.copyOfRange(headerRow, numHeaderCols, numCols);
            try {
                markers = SimpleGenotypeData.inferMarkerNames(dataColumnNames);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex);
            }
            int numMarkers = markers.size();
            String[] markerNames = ((HashMap)markers).keySet().toArray(new String[0]);
            Integer[] markerNumCols = ((HashMap)markers).values().toArray(new Integer[0]);
            String[] itemNames = new String[n];
            String[] itemIdentifiers = new String[n];
            for (int i = 0; i < n; ++i) {
                String[] row3 = (String[])rows.get(i + 1);
                itemIdentifiers[i] = row3[0];
                itemNames[i] = withNames ? row3[1] : itemIdentifiers[i];
            }
            String[][][] observedAlleles = new String[n][numMarkers][];
            for (int i = 0; i < n; ++i) {
                String[] row4 = (String[])rows.get(i + 1);
                int c = numHeaderCols;
                for (int m = 0; m < numMarkers; ++m) {
                    int nCol = markerNumCols[m];
                    observedAlleles[i][m] = new String[nCol];
                    for (int mc = 0; mc < nCol; ++mc) {
                        observedAlleles[i][m][mc] = row4[c++];
                    }
                }
            }
            try {
                SimpleGenotypeData i = SimpleGenotypeData.createDefaultData(observedAlleles, itemIdentifiers, itemNames, markerNames, filePath.getFileName().toString());
                return i;
            }
            catch (IllegalArgumentException ex) {
                try {
                    throw new IOException(ex);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static SimpleGenotypeData createDefaultData(String[][][] data, String[] ids, String[] names, String[] markerNames) {
        return SimpleGenotypeData.createDefaultData(data, ids, names, markerNames, null);
    }

    public static SimpleGenotypeData createDefaultData(String[][][] data, String[] ids, String[] names, String[] markerNames, String dataName) {
        int i;
        int n = data.length;
        int numMarkers = data[0].length;
        String[][] alleleNames = new String[numMarkers][];
        for (int m = 0; m < numMarkers; ++m) {
            TreeSet<String> alleles = new TreeSet<String>();
            for (i = 0; i < n; ++i) {
                for (String observed : data[i][m]) {
                    if (observed == null) continue;
                    alleles.add(observed);
                }
            }
            if (alleles.isEmpty()) {
                throw new IllegalArgumentException(String.format("No data for marker %s.", markerNames[m]));
            }
            alleleNames[m] = alleles.toArray(new String[alleles.size()]);
        }
        Double[][][] alleleFreqs = new Double[n][numMarkers][];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int m = 0; m < numMarkers; ++m) {
                String[] markerAlleleNames = alleleNames[m];
                int totalNumAlleles = markerAlleleNames.length;
                String[] observed = data[i2][m];
                Object[] freqs = new Double[totalNumAlleles];
                if (Arrays.stream(observed).noneMatch(Objects::isNull)) {
                    Arrays.fill(freqs, (Object)0.0);
                }
                double incr = 1.0 / (double)observed.length;
                for (int possibleAllele = 0; possibleAllele < totalNumAlleles; ++possibleAllele) {
                    for (int observedAllele = 0; observedAllele < observed.length; ++observedAllele) {
                        if (!markerAlleleNames[possibleAllele].equals(observed[observedAllele])) continue;
                        SimpleGenotypeData.increaseFrequency((Double[])freqs, possibleAllele, incr);
                    }
                }
                alleleFreqs[i2][m] = freqs;
            }
        }
        SimpleEntity[] headers = new SimpleEntity[n];
        for (i = 0; i < n; ++i) {
            headers[i] = names[i] != null ? new SimpleEntityPojo(ids[i], names[i]) : new SimpleEntityPojo(ids[i]);
        }
        if (dataName != null) {
            return new SimpleGenotypeData(dataName, headers, markerNames, alleleNames, alleleFreqs);
        }
        return new SimpleGenotypeData(headers, markerNames, alleleNames, alleleFreqs);
    }

    private static String inferMarkerName(String columnName) {
        int i = Stream.of(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.')).mapToInt(suf -> columnName.lastIndexOf(suf.charValue())).max().orElse(-1);
        String markerName = i >= 0 ? columnName.substring(0, i) : columnName;
        return markerName;
    }

    public static LinkedHashMap<String, Integer> inferMarkerNames(String[] columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("Column names undefined.");
        }
        LinkedHashMap<String, Integer> markerNames = new LinkedHashMap<String, Integer>();
        String curName = null;
        for (int c = 0; c < columnNames.length; ++c) {
            String columnName = columnNames[c];
            if (columnName == null) {
                throw new IllegalArgumentException("Missing column name for column " + c + ".");
            }
            String markerName = SimpleGenotypeData.inferMarkerName(columnName);
            if (markerName.equals("")) {
                throw new IllegalArgumentException(String.format("Invalid marker name at column %d (%s).", c, columnName));
            }
            if (curName == null || !markerName.equals(curName)) {
                if (markerNames.containsKey(markerName)) {
                    throw new IllegalArgumentException("Duplicate marker name: " + markerName + ". " + "Columns corresponding to same marker should occur consecutively.");
                }
                markerNames.put(markerName, 1);
                curName = markerName;
                continue;
            }
            markerNames.put(markerName, markerNames.get(markerName) + 1);
        }
        return markerNames;
    }

    private static void increaseFrequency(Double[] freqs, int a, double incr) {
        freqs[a] = freqs[a] == null ? incr : freqs[a] + incr;
    }

    public List<GenotypeDataFormat> getSupportedOutputFormats() {
        return Collections.singletonList(GenotypeDataFormat.FREQUENCY);
    }

    public void writeData(Path filePath, FileType fileType) throws IOException {
        this.writeData(filePath, fileType, GenotypeDataFormat.FREQUENCY);
    }

    public void writeData(Path filePath, FileType fileType, GenotypeDataFormat format) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (filePath.toFile().exists()) {
            throw new IOException("File already exists : " + filePath + ".");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (fileType != FileType.TXT && fileType != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{fileType}));
        }
        if (format != GenotypeDataFormat.FREQUENCY) {
            throw new IllegalArgumentException("Unsupported output format: " + (Object)((Object)format));
        }
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        try (RowWriter writer = IOUtilities.createRowWriter(filePath, fileType, 16);){
            int i;
            if (writer == null || !writer.ready()) {
                throw new IOException("Can not create writer for file " + filePath + ".");
            }
            writer.writeCell(IDENTIFIERS_HEADER);
            writer.newColumn();
            writer.writeCell(NAMES_HEADER);
            for (i = 0; i < this.alleleNames.length; ++i) {
                for (int j = 0; j < this.alleleNames[i].length; ++j) {
                    writer.newColumn();
                    writer.writeCell(this.markerNames[i]);
                }
            }
            writer.newRow();
            writer.writeCell(ALLELE_NAMES_HEADER);
            writer.newColumn();
            for (i = 0; i < this.alleleNames.length; ++i) {
                writer.newColumn();
                writer.writeRowCellsAsArray(this.alleleNames[i]);
            }
            for (int i2 = 0; i2 < this.alleleFrequencies.length; ++i2) {
                writer.newRow();
                SimpleEntity header = this.getHeader(i2);
                writer.writeCell(header.getUniqueIdentifier());
                writer.newColumn();
                writer.writeCell(header.getName());
                for (int j = 0; j < this.alleleFrequencies[i2].length; ++j) {
                    writer.newColumn();
                    writer.writeRowCellsAsArray(this.alleleFrequencies[i2][j]);
                }
            }
            writer.close();
        }
    }
}

