/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.distance.measures;

import java.util.HashMap;
import java.util.Map;
import org.corehunter.data.CoreHunterData;
import org.corehunter.objectives.distance.DistanceMeasure;
import org.corehunter.objectives.distance.measures.MissingValuesPolicy;

public abstract class AbstractDistanceMeasure
implements DistanceMeasure {
    private final Map<CoreHunterData, Double[][]> cache = new HashMap<CoreHunterData, Double[][]>();
    private MissingValuesPolicy missingValuesPolicy;

    public AbstractDistanceMeasure() {
        this(MissingValuesPolicy.FLOOR);
    }

    public AbstractDistanceMeasure(MissingValuesPolicy policy) {
        this.setMissingValuesPolicy(policy);
    }

    @Override
    public double getDistance(int idX, int idY, CoreHunterData data) {
        Double[][] distances = this.cache.get(data);
        if (distances != null && distances[idX][idY] != null) {
            return distances[idX][idY];
        }
        if (distances == null) {
            int n = data.getSize();
            distances = new Double[n][n];
            this.cache.put(data, distances);
        }
        double d = idX != idY ? this.computeDistance(idX, idY, data) : 0.0;
        distances[idX][idY] = d;
        distances[idY][idX] = d;
        return d;
    }

    protected abstract double computeDistance(int var1, int var2, CoreHunterData var3);

    @Override
    public final void setMissingValuesPolicy(MissingValuesPolicy policy) {
        if (this.missingValuesPolicy != policy) {
            this.missingValuesPolicy = policy;
            this.cache.clear();
        }
    }

    protected double missingValueContribution(double ceilValue) {
        switch (this.missingValuesPolicy) {
            case FLOOR: {
                return 0.0;
            }
            case CEIL: {
                return ceilValue;
            }
        }
        throw new RuntimeException("This should not happen: unexpected missing values policy " + (Object)((Object)this.missingValuesPolicy));
    }
}

