% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim2ddata.R
\name{sim2ddata}
\alias{sim2ddata}
\title{Simulate kinetic data from two-step sequential first-order reactions}
\usage{
sim2ddata(
  L = 400,
  t = 0:10,
  k1 = 0.2,
  k2 = 0.8,
  X = c(1000, 1400),
  A = c(1080, 1320),
  Aamp = c(3, 8),
  B = c(1120, 1280),
  Bamp = c(5, 15),
  C = c(1160, 1240),
  Camp = c(4, 9)
)
}
\arguments{
\item{L}{Positive, non-zero integer specifying how many spectral variables
should be used to describe the kinetic dataset.}

\item{t}{Numeric vector containing non-negative real numbers describing at
which reaction times the kinetic data should be sampled.}

\item{k1, k2}{Positive, non-zero real numbers describing the time constants
used to simulate the reactions A -> B (\code{k1}) and B -> C (\code{k2}).}

\item{X}{Numeric vector with two values specifying the range of the simulated
spectral variables.}

\item{A, B, C}{Numeric vector with two real values specifying the two signal
positions of species A, B and C, respectively. It's the \code{mean} used
in \code{\link[stats]{dnorm}} to simulate the signal. C and Camp may be
NULL in which case only the reaction A -> B is simulated and sampled.}

\item{Aamp, Bamp, Camp}{Numeric vector with two values specifying the signal
width of species A, B and C, respectively. It's the standard deviation
(\code{sd}) used in \code{\link[stats]{dnorm}} to simulate the signal. 
C and Camp may be NULL in which case only the reaction A -> B is
simulated and sampled.}
}
\value{
\code{sim2ddata} returns a matrix containing the kinetic data. The
    matrix contains the sampled reaction times by rows and the spectral
    variables by columns. The reaction times are the row names while the
    spectral variables are saved as the column names. The matrix has the
    ideal format to be analyzed by \code{\link[corr2D]{corr2d}}.
}
\description{
\code{sim2ddata} simulates kinetic data for the sequential reaction
    A -> B -> C with the time constants k1 and k2.
}
\details{
The simulation assumes 2 spectral signals for each of the 3 species A, B
    and C. The sequential reaction is defined by 2 time constants k1 and k2.
    The spectral information can be sampled at every point during the
    reaction to get an arbitrary profile of the kinetic data. The signals of
    the three species are modeled by a normal distribution. In addition the
    spectral variable is assumed to be equidistant and the number of spectral
    variables can also be chosen arbitrary.
}
\examples{
    testdata <- sim2ddata()
    
    twodtest <- corr2d(testdata, corenumber = 1)
    
    plot_corr2d(twodtest)

}
\references{
The default values are inspired by:
    I. Noda (2014) <DOI:10.1016/j.molstruc.2014.01.024>
}
