% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Counterfactuals.R
\name{Counterfactuals}
\alias{Counterfactuals}
\title{Counterfactuals Class}
\description{
A \code{Counterfactuals} object should be created by the \verb{$find_counterfactuals} method of \link{CounterfactualMethodRegr}
or \link{CounterfactualMethodClassif}.
It contains the counterfactuals and has several methods for their evaluation and visualization.
}
\references{
Gower, J. C. (1971), "A general coefficient of similarity and some of its properties". Biometrics, 27, 623–637.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{desired}}{(\code{list(1)} | \code{list(2)})\cr
A \code{list} with the desired properties of the counterfactuals.
For regression tasks it has one element \code{desired_outcome} (\link{CounterfactualMethodRegr}) and for
classification tasks two elements \code{desired_class} and \code{desired_prob} (\link{CounterfactualMethodClassif}).}

\item{\code{data}}{(\code{data.table})\cr
The counterfactuals for \code{x_interest}.}

\item{\code{x_interest}}{(\code{data.table(1)}) \cr
A single row with the observation of interest.}

\item{\code{distance_function}}{(\verb{function()}) \cr
The distance function used in the second and fourth evaluation measure.
The function must have three arguments:
\code{x}, \code{y}, and \code{data} and return a \code{numeric} matrix. If set to \code{NULL} (default), then Gower distance (Gower 1971) is used.}

\item{\code{method}}{(\code{character}) \cr
A single row with the observation of interest.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Counterfactuals-new}{\code{Counterfactuals$new()}}
\item \href{#method-Counterfactuals-evaluate}{\code{Counterfactuals$evaluate()}}
\item \href{#method-Counterfactuals-evaluate_set}{\code{Counterfactuals$evaluate_set()}}
\item \href{#method-Counterfactuals-predict}{\code{Counterfactuals$predict()}}
\item \href{#method-Counterfactuals-subset_to_valid}{\code{Counterfactuals$subset_to_valid()}}
\item \href{#method-Counterfactuals-revert_subset_to_valid}{\code{Counterfactuals$revert_subset_to_valid()}}
\item \href{#method-Counterfactuals-plot_parallel}{\code{Counterfactuals$plot_parallel()}}
\item \href{#method-Counterfactuals-plot_freq_of_feature_changes}{\code{Counterfactuals$plot_freq_of_feature_changes()}}
\item \href{#method-Counterfactuals-get_freq_of_feature_changes}{\code{Counterfactuals$get_freq_of_feature_changes()}}
\item \href{#method-Counterfactuals-plot_surface}{\code{Counterfactuals$plot_surface()}}
\item \href{#method-Counterfactuals-print}{\code{Counterfactuals$print()}}
\item \href{#method-Counterfactuals-clone}{\code{Counterfactuals$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-new"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{Counterfactuals} object.
This method should only be called by the \verb{$find_counterfactuals} methods of \link{CounterfactualMethodRegr}
and \link{CounterfactualMethodClassif}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$new(
  cfactuals,
  predictor,
  x_interest,
  param_set,
  desired,
  method = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cfactuals}}{(\code{data.table}) \cr
The counterfactuals. Must have the same column names and types as \code{predictor$data$X}.}

\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{x_interest}}{(\code{data.table(1)} | \code{data.frame(1)}) \cr
A single row with the observation of interest.}

\item{\code{param_set}}{(\link[paradox]{ParamSet})\cr
A \link[paradox]{ParamSet} based on the features of \code{predictor$data$X}.}

\item{\code{desired}}{(\code{list(1)} | \code{list(2)})\cr
A \code{list} with the desired properties of the counterfactuals. It should have one element \code{desired_outcome} for
regression tasks (\link{CounterfactualMethodRegr}) and two elements \code{desired_class} and \code{desired_prob}
for classification tasks (\link{CounterfactualMethodClassif}).}

\item{\code{method}}{(\code{character}) \cr
Name of the method with which counterfactuals were generated. Default is
NULL which means that no name is provided.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluates the counterfactuals. It returns the counterfactuals together with the evaluation \code{measures}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$evaluate(
  measures = c("dist_x_interest", "dist_target", "no_changed", "dist_train",
    "minimality"),
  show_diff = FALSE,
  k = 1L,
  weights = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{(\code{character}) \cr
The name of one or more evaluation measures.
The following measures are available:
\itemize{
\item \code{dist_x_interest}: The distance of a counterfactual to \code{x_interest} measured by Gower's
dissimilarity measure (Gower 1971).
\item \code{dist_target}: The absolute distance of the prediction for a counterfactual to the interval \code{desired_outcome}
(regression tasks) or \code{desired_prob} (classification tasks).
\item \code{no_changed}: The number of feature changes w.r.t. \code{x_interest}.
\item \code{dist_train}: The (weighted) distance to the \code{k} nearest training data points measured by Gower's
dissimilarity measure (Gower 1971).
\item \code{minimality}: The number of changed features that each could be set to the
value of \code{x_interest} while keeping the desired prediction value.
}}

\item{\code{show_diff}}{(\code{logical(1)})\cr
Should the counterfactuals be displayed as their differences to \code{x_interest}? Default is \code{FALSE}.
If set to \code{TRUE}, positive values for numeric features indicate an increase compared to the feature value in
\code{x_interest}, negative values indicate a decrease. For factors, the feature value is displayed if it differs
from \code{x_interest}; \code{NA} means "no difference" in both cases.}

\item{\code{k}}{(\code{integerish(1)}) \cr
How many nearest training points should be considered for computing the \code{dist_train} measure? Default is \code{1L}.}

\item{\code{weights}}{(\code{numeric(k)} | \code{NULL}) \cr
How should the \code{k} nearest training points be weighted when computing the \code{dist_train} measure? If \code{NULL}
(default) then all \code{k} points are weighted equally. If a numeric vector of length \code{k} is given, the i-th element
specifies the weight of the i-th closest data point.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-evaluate_set"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-evaluate_set}{}}}
\subsection{Method \code{evaluate_set()}}{
Evaluates a set of counterfactuals. It returns the evaluation \code{measures}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$evaluate_set(
  measures = c("diversity", "no_nondom", "frac_nondom", "hypervolume"),
  nadir = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{(\code{character}) \cr
The name of one or more evaluation measures.
The following measures are available:
\itemize{
\item \code{diversity}: Diversity of returned counterfactuals in the feature space
\item \code{no_nondom}: Number of counterfactuals that are not dominated by other
counterfactuals.
\item \code{frac_nondom}: Fraction of counterfactuals that are not dominated by
other counterfactuals
\item \code{hypervolume}: Hypervolume of the induced Pareto front
}}

\item{\code{nadir}}{(\code{numeric}) \cr Max objective values to calculate dominated hypervolume.
Only considered, if \code{hypervolume} is one of the \code{measures}.
May be a scalar, in which case it is used for all four objectives,
or a vector of length 4.
Default is NULL, meaning the nadir point by Dandl et al. (2020) is used:
(min distance between prediction of \code{x_interest} to \verb{desired_prob/_outcome},
1, number of features, 1).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-predict"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-predict}{}}}
\subsection{Method \code{predict()}}{
Returns the predictions for the counterfactuals.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$predict()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-subset_to_valid"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-subset_to_valid}{}}}
\subsection{Method \code{subset_to_valid()}}{
Subset data to those meeting the desired prediction,
Process could be reverted using \code{revert_subset_to_valid()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$subset_to_valid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-revert_subset_to_valid"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-revert_subset_to_valid}{}}}
\subsection{Method \code{revert_subset_to_valid()}}{
Subset data to those meeting the desired prediction,
Process could be reverted using \code{revert_subset_to_valid()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$revert_subset_to_valid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-plot_parallel"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-plot_parallel}{}}}
\subsection{Method \code{plot_parallel()}}{
Plots a parallel plot that connects the (scaled) feature values of each counterfactual and highlights
\code{x_interest} in blue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$plot_parallel(
  feature_names = NULL,
  row_ids = NULL,
  digits_min_max = 2L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_names}}{(\code{character} | \code{NULL})\cr
The names of the (numeric) features to display. If \code{NULL} (default) all features are displayed.}

\item{\code{row_ids}}{(\code{integerish} | \code{NULL})\cr
The row ids of the counterfactuals to display. If \code{NULL} (default) all counterfactuals are displayed.}

\item{\code{digits_min_max}}{Maximum number of digits for the minimum and maximum features values. Default is \code{2L}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-plot_freq_of_feature_changes"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-plot_freq_of_feature_changes}{}}}
\subsection{Method \code{plot_freq_of_feature_changes()}}{
Plots a bar chart with the frequency of feature changes across all counterfactuals.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$plot_freq_of_feature_changes(subset_zero = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subset_zero}}{(\code{logical(1)})\cr
Should unchanged features be excluded from the plot? Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-get_freq_of_feature_changes"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-get_freq_of_feature_changes}{}}}
\subsection{Method \code{get_freq_of_feature_changes()}}{
Returns the frequency of feature changes across all counterfactuals.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$get_freq_of_feature_changes(subset_zero = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subset_zero}}{(\code{logical(1)})\cr
Should unchanged features be excluded? Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A (named) \code{numeric} vector with the frequency of feature changes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-plot_surface"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-plot_surface}{}}}
\subsection{Method \code{plot_surface()}}{
Creates a surface plot for two features. \code{x_interest} is represented as a white dot and
all counterfactuals that differ from \code{x_interest} \strong{only} in the two selected features are represented as black dots.
The tick marks next to the axes show the marginal distribution of the observed data (\code{predictor$data$X}). \cr
The exact plot type depends on the selected feature types and number of features:
\itemize{
\item 2 numeric features: surface plot
\item 2 non-numeric features: heatmap
\item 1 numeric or non-numeric feature: line graph
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$plot_surface(feature_names, grid_size = 250L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_names}}{(\code{character(2)})\cr
The names of the features to plot.}

\item{\code{grid_size}}{(\code{integerish(1)})\cr
The grid size of the plot. It is ignored in case of two \code{non-numeric} features. Default is \code{250L}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-print"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-print}{}}}
\subsection{Method \code{print()}}{
Prints the \code{Counterfactuals} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Counterfactuals-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Counterfactuals-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Counterfactuals$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
