% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.countgmifs.R
\name{predict.countgmifs}
\alias{predict.countgmifs}
\alias{fitted.countgmifs}
\title{Predict Outcome for Count GMIFS Fitted Model.}
\usage{
\method{predict}{countgmifs}(object, neww = NULL, newdata, newx = NULL,
  model.select = "BIC", newoffset=NULL, ...)
}
\arguments{
\item{object}{an \code{ordinalgmifs} fitted object.}

\item{neww}{an optional formula that includes the unpenalized variables to use for predicting the response. If omitted, the training data are used.}

\item{newdata}{an optional data.frame that minimally includes the unpenalized variables to use for predicting the response. If omitted, the training data are used.}

\item{newx}{an optional matrix of penalized variables to use for predicting the response. If omitted, the training data are used.}

\item{model.select}{when \code{x} is specified any model along the solution path can be selected. The default is \code{model.select="BIC"} which calculates the predicted values using the coefficients from the model having the lowest BIC. Other options are \code{model.select="AIC"} or any numeric value from the solution path.}

\item{newoffset}{If an offset is used in the fit, then one must be supplied for making predictions.}

\item{...}{other arguments.}
}
\description{
This function returns a numeric vector that is the predicted response from the \code{countgmifs} fitted object.
}
\seealso{
See Also \code{\link{countgmifs}}, \code{\link{coef.countgmifs}}, \code{\link{summary.countgmifs}}, \code{\link{plot.countgmifs}}
}
\keyword{methods}
