% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_cluster.R
\name{Cluster}
\alias{Cluster}
\title{Perform spectral clustering on dot products.}
\usage{
Cluster(C, n_clusters, n_components = NULL)
}
\arguments{
\item{C}{countland object}

\item{n_clusters}{number of clusters, integer}

\item{n_components}{number of components from spectral embedding to use (default NULL, will be set to n_clusters), integer}
}
\value{
countland object with slot \code{cluster_labels}
}
\description{
Perform spectral clustering on dot products.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- Dot(C)
C <- Embed(C,n_components=5)
C <- Cluster(C,n_clusters=3)
}
