% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_county_cd}
\alias{get_county_cd}
\title{Get all FIPS county codes within a state}
\usage{
get_county_cd(state)
}
\arguments{
\item{state}{Character vector giving the name of state or states (not case
sensitive) for which you would like to get county FIPS codes.}
}
\value{
A character vector with the 5-digit FIPS codes for all counties
   within the specified state or states.
}
\description{
This function will return all county FIPS codes for all counties within a
state or states.
}
\details{
This function uses the \code{county.fips} dataset from the \code{maps}
   package to pull county FIPS for a state.
}
\examples{
 get_county_cd("Virginia")
 get_county_cd(c("North Carolina", "South Carolina"))

}
