% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_fips.R
\name{hourly_df}
\alias{hourly_df}
\title{Return average hourly weather data for a particular county.}
\usage{
hourly_df(fips, year, var = "all", average_data = TRUE, coverage = NULL)
}
\arguments{
\item{fips}{A character string of the five-digit U.S. FIPS code of a U.S.
county.}

\item{year}{A four-digit number or vector of numbers indicating the year or
years for which you want to pull hourly data. Values for \code{year} can
be in the range from 1901 to the current year.}

\item{var}{A character vector specifying desired weather variables. For
example, \code{var = c("wind_speed", "temperature")} pulls data on hourly
wind speed and temperature. The core weather variables
available include \code{"wind_direction"}, \code{"wind_speed"},
\code{"ceiling_height"}, \code{"visibility_distance"}, \code{"temperature"},
\code{"temperature_dewpoint"}, \code{"air_pressure"}. Alternatively, you
can specify var = "all" to include additional flag and quality codes.}

\item{average_data}{TRUE / FALSE to indicate if you want the function to
average daily weather data across multiple monitors.}

\item{coverage}{A numeric value in the range of 0 to 1 that specifies
the desired percentage coverage for the weather variable (i.e., what
percent of each weather variable must be non-missing to include data from
a monitor when calculating daily values averaged across monitors).}
}
\value{
A list with five elements. The first element, \code{hourly_data}, is
   a dataframe of hourly weather data averaged across multiple stations,
   as well as columns (\code{"var"_reporting}) for each weather variable
   showing the number of stations contributing to the average for that
   variable for each hour. \code{station_df} is a dataframe of station
   metadata for each station contributing weather data. A weather station
   will have one row per weather variable to which it contributes data. In
   addition to information such as USAF and WBAN ids and station names, this
   dataframe includes statistical information about weather values
   contributed by each station for each weather variable. These statistics
   include calculated coverage (\code{calc_coverage}), which is the percent
   of non-missing values for each station and variable for the specified
   date range, \code{standard_dev} (standard deviation), \code{max},
   \code{min}, and \code{range} values for each station-weather variable
   combination. The element \code{radius} is the calculated radius within
   which stations were pulled from the county's center. Elements
   \code{lat_center} and \code{lon_center} are the latitude and longitude of
   the county's geographic center.
}
\description{
Returns a dataframe of average daily weather values
for a particular county, year, weather variables, and/or specified coverage.
}
\details{
This function serves as a wrapper to several functions from the \code{rnoaa}
package, which provides weather data from all relevant stations in a county.
This function filters and averages across NOAA ISD/ISH stations based on
user-specified coverage specifications.
}
\note{
Observation times are based on Coordinated Universal Time Code (UTC).
}
\examples{
\dontrun{
df <- hourly_df(fips = "12086", year = 1992,
                var = c("wind_speed", "temperature"))
head(df$hourly_data)
head(df$station_df)
df$radius
}

}
\references{
For more information on this dataset and available weather and
flag/quality variables, see
\url{ftp://ftp.ncdc.noaa.gov/pub/data/noaa/ish-format-document.pdf}.
}

