% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covastat.R
\docType{class}
\name{covastat-class}
\alias{covastat-class}
\alias{covastat}
\alias{show,covastat-method}
\alias{covastat-class}
\title{Class "covastat"}
\usage{
covastat(matdata, pardata1, pardata2, stpairs, typetest = 0,
  beta.data = NULL)

\S4method{show}{covastat}(object)
}
\arguments{
\item{matdata}{STFDF/STSDF or \code{data.frame}; which contains the
coordinates of the spatial points, the identification code of the spatial
points, the indentification code of the temporal points and the values of
the variable, typically output from \code{dataprep}}

\item{pardata1}{integer, it represents the column in which the spatial ID is
stored (if the spatio-temporal data set is given as data.frame) or the number of
variables in the STFDF/STSDF (if the data are given as a STFDF/STSDF)}

\item{pardata2}{integer, it represents the column in which the values of the
variable are stored (if the spatio-temporal data set is given as data.frame) or
the slot in which the values of the variable of interest are stored
(if the data are given as a STFDF/STSDF). Note that for STFDF/STSDF the
argument is set, by default, equal to 1 if the number of variables is equal to 1}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{integer; set \code{typetest=0} for symmetry test (default
choice), \code{typetest=1} for separability test, \code{typetest=2} for type
of non separability test, \code{typetest=3} for the test on the product-sum
class of models, \code{typetest=4} for the test on the integrated product
class of models, \code{typetest=5} for the test on the Gneiting class of
models}

\item{beta.data}{vector; this argument is required only for \code{typetest=5},
otherwise it has to be set equal to NULL (default choice). It contains the
different values of the parameter beta, which can assume values in the range 0-1}

\item{object}{object of class \code{covastat} for method \code{show}}
}
\description{
A class for the sample spatio-temporal covariances for the specified spatial
and temporal lags, given in \code{stpairs} (object of class \code{couple}).
Depending on the type of test, the empirical variance, the sample spatial
and temporal marginal covariances are also computed.
}
\details{
A message appears on the user's console if the \code{G} vector
contains spatio-temporal negative covariances. The message returns the negative
value/values and it will help to identify the spatial and the temporal lags
involved.
}
\section{Slots}{

\describe{
\item{\code{G}}{matrix; containing the spatio-temporal covariances for the specified
lags. For all tests, except for the symmetry test (\code{typetest=0}), the
sample variance and the sample spatial and temporal marginal covariances are
also computed and stored in \code{G}}

\item{\code{cova.h}}{matrix; containing the sample spatial marginal covariances
for the specified lags}

\item{\code{cova.u}}{matrix; containing the sample temporal marginal covariances
for the specified lags}

\item{\code{f.G}}{array; containing the computation of specific functions of the
elements of \code{G}, see references}

\item{\code{B}}{matrix; containing the computation of the derivatives of each element
of \code{f.G} with respect to each element of \code{G}}

\item{\code{A}}{contrast matrix}

\item{\code{beta.data}}{vector; containing the different values of the parameter beta,
available only for the test on the Gneiting class of model (\code{typetest=5})}

\item{\code{typetest}}{numeric; contains the code of the test to be performed}
}}

\note{
{
A stop occurs if the number of spatial points fixed in \code{stpairs}
(object of class \code{couples}) is less than 2.
\itemize{
\item If \code{typetest} is equal to 0 (symmetry test) \code{cova.h}, \code{cova.u},
\code{f.G} and \code{B} are not available

\item If \code{typetest} is equal to 4 (test on the integrated product class
of models) \code{cova.h} and \code{cova.u} are not available

\item If \code{typetest} is equal to 5 (test on the Gneiting class of models),
\code{cova.h} is not available
}
}
}
\examples{
sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = 0, typecode = character())

covast.sym <- covastat(matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym, typetest = 0, beta.data = NULL)

###method for covastat
#1. show
covast.sym

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2017, Testing the type of
non-separability and some classes of covariance models for space-time data.
Stochastic Environmental Research and Risk Assessment,
doi 10.1007/s00477-017-1472-2
}
\seealso{
\linkS4class{couples}

\code{\link{dataprep}}
}
