% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exclusions.R
\name{exclusions}
\alias{exclusions}
\title{Exclusions}
\description{
covr supports a couple of different ways of excluding some or all of a file.
}
\section{Exclusions Argument}{


The exclusions argument to \code{package_coverage()} can be used to exclude some or
all of a file.  This argument takes a list of filenames or named ranges to
exclude.
}

\section{Exclusion Comments}{


In addition you can exclude lines from the coverage by putting special comments
in your source code. This can be done per line or by specifying a range.
The patterns used can be specified by the \code{exclude_pattern}, \code{exclude_start},
\code{exclude_end} arguments to \code{package_coverage()} or by setting the global
options \code{covr.exclude_pattern}, \code{covr.exclude_start}, \code{covr.exclude_end}.
}
\examples{
\dontrun{
# exclude whole file of R/test.R
package_coverage(exclusions = "R/test.R")

# exclude lines 1 to 10 and 15 from R/test.R
package_coverage(exclusions = list("R/test.R" = c(1:10, 15)))

# exclude lines 1 to 10 from R/test.R, all of R/test2.R
package_coverage(exclusions = list("R/test.R" = 1:10, "R/test2.R"))

# single line exclusions
f1 <- function(x) {
  x + 1 # nocov
}

# ranged exclusions
f2 <- function(x) { # nocov start
  x + 2
} # nocov end
}
}

