% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSIM.R
\name{rPLSIM}
\alias{rPLSIM}
\title{Simulation of non-normal data}
\usage{
rPLSIM(
  N,
  sigma.target,
  skewness,
  excesskurtosis,
  reps = 1,
  numsegments = 4,
  gammalist = NULL,
  monot = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{N}{Number of observations to simulate.}

\item{sigma.target}{Target population covariance matrix}

\item{skewness}{Target skewness}

\item{excesskurtosis}{Target excess kurtosis}

\item{reps}{Number of simulated samples}

\item{numsegments}{The number of line segments in each marginal}

\item{gammalist}{A list of breakpoints in each margin}

\item{monot}{True if piecewise linear functions are forced to be monotonous. The copula will then be normal.}

\item{verbose}{If true, progress details of the procedure are printed}
}
\value{
A list with two elements. First element: the list of simulated samples. Second element: The fitted piecewise linear functions and the intermediate correlations matrix.
}
\description{
Using the piecewise linear PLSIM method to simulate non-normal data
}
\examples{
#'set.seed(1)
sigma.target  <- cov(MASS::mvrnorm(5, rep(0,3), diag(3)))
res  <- covsim::rPLSIM(10^5, sigma.target, skewness=rep(1,3), excesskurtosis=rep(4,3))
my.sample  <- res[[1]][[1]]
}
\references{
Foldnes, N. and Grønneberg S. (2021). Non-normal data simulation using piecewise linear transforms.Under review.
}
\author{
Njål Foldnes  (\email{njal.foldnes@gmail.com})
}
