% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try_emplace.R
\name{try_emplace}
\alias{try_emplace}
\alias{try_emplace,CppMap-method}
\alias{try_emplace,CppUnorderedMap-method}
\title{Add an element}
\usage{
try_emplace(x, value, key)
}
\arguments{
\item{x}{A CppMap or CppUnorderedMap object.}

\item{value}{A value to add to \code{x}.}

\item{key}{A key to add to \code{x}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Add an element to a container by reference in place, if it does not exist yet.
}
\details{
Existing container values are not overwritten. I.e., inserting a key-value pair into a map that already contains that key preserves the old 
value and discards the new one. Use \link{insert_or_assign} to overwrite values.

\link{emplace} and \code{try_emplace} produce the same results in the context of this package. \code{try_emplace} can be minimally more computationally 
efficient than \link{emplace}.
}
\examples{
m <- cpp_map(4:6, 9:11)
m
# [4,9] [5,10] [6,11]

try_emplace(m, 13L, 8L)
m
# [4,9] [5,10] [6,11] [8,13]

try_emplace(m, 12L, 4L)
m
# [4,9] [5,10] [6,11] [8,13]

}
\seealso{
\link{emplace}, \link{emplace_after}, \link{emplace_back}, \link{emplace_front}, \link{insert}, \link{insert_or_assign}.
}
