% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{mcmc_pol_wrapper}
\alias{mcmc_pol_wrapper}
\title{Wrapper of mcmc_pol}
\usage{
mcmc_pol_wrapper(
  df,
  seed,
  alpha_init = 1.5,
  theta_init = 0.5,
  m_alpha = 0,
  s_alpha = 10,
  a_theta = 1,
  b_theta = 1,
  a_pseudo = 10,
  b_pseudo = 1,
  pr_power = 0.5,
  iter = 20000L,
  thin = 20L,
  burn = 100000L,
  freq = 1000L,
  mc3 = FALSE,
  invts = 0.001^((0:8)/8)
)
}
\arguments{
\item{df}{A data frame with at least two columns, x & count}

\item{seed}{Integer for \code{set.seed}}

\item{alpha_init}{Real number greater than 1, initial value of the parameter}

\item{theta_init}{Real number in (0, 1], initial value of the parameter}

\item{m_alpha}{Real number, mean of the prior normal distribution for alpha}

\item{s_alpha}{Positive real number, standard deviation of the prior normal distribution for alpha}

\item{a_theta}{Positive real number, first parameter of the prior beta distribution for theta; ignored if pr_power = 1.0}

\item{b_theta}{Positive real number, second parameter of the prior beta distribution for theta; ignored if pr_power = 1.0}

\item{a_pseudo}{Positive real number, first parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{b_pseudo}{Positive real number, second parameter of the pseudoprior beta distribution for theta in model selection; ignored if pr_power = 1.0}

\item{pr_power}{Real number in [0, 1], prior probability of the discrete power law}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{mc3}{Boolean, is Metropolis-coupled MCMC to be used?}

\item{invts}{Vector of the inverse temperatures for Metropolis-coupled MCMC}
}
\value{
A list returned by \code{mcmc_pol}
}
\description{
Wrapper of mcmc_pol
}
