% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_score_card.R
\name{get_score_card}
\alias{get_score_card}
\title{Score Card}
\usage{
get_score_card(lg_model, target, bins_table, a = 600, b = 50,
  file_name = NULL, dir_path = tempdir(), save_data = FALSE)
}
\arguments{
\item{lg_model}{An object of glm model.}

\item{target}{The name of target variable.}

\item{bins_table}{a data.frame generated by \code{\link{get_bins_table}}}

\item{a}{Base line of score.}

\item{b}{Numeric.Increased scores from doubling Odds.}

\item{file_name}{The name for periodically saved scorecard file. Default is "LR_Score_Card".}

\item{dir_path}{The path for periodically saved scorecard file. Default is "./model"}

\item{save_data}{Logical, save results in locally specified folder. Default is TRUE}
}
\value{
scorecard
}
\description{
\code{get_score_card} is  for generating a stardard scorecard
}
\examples{
# dataset spliting
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
#rename the target variable
dat = re_name(dat, "default.payment.next.month", "target")
dat = cleaning_data(dat, target = "target", obs_id = "ID", 
occur_time = "apply_date", miss_values =  list("", -1))
#train_ test pliting
train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
#get breaks of all predictive variables
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "EDUCATION", "PAY_3", "PAY_2")
breaks_list <- get_breaks_all(dat = dat_train, target = "target",
                              x_list = x_list, occur_time = "apply_date", ex_cols = "ID", 
save_data = FALSE, note = FALSE)
#woe transforming
train_woe = woe_trans_all(dat = dat_train,
                          target = "target",
                          breaks_list = breaks_list,
                          woe_name = FALSE)
test_woe = woe_trans_all(dat = dat_test,
                       target = "target",
                         breaks_list = breaks_list,
                         note = FALSE)
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = train_woe[, c("target", x_list)], family = binomial(logit))
#get LR coefficient
dt_imp_LR = get_logistic_coef(lg_model = lr_model, save_data = FALSE)
bins_table = get_bins_table_all(dat = dat_train, target = "target",
                               occur_time = "apply_date",
                                x_list = x_list,
                               breaks_list = breaks_list, note = FALSE)
#score card
LR_score_card <- get_score_card(lg_model = lr_model, bins_table, target = "target")
#scoring
train_pred = dat_train[, c("ID", "apply_date", "target")]
test_pred = dat_test[, c("ID", "apply_date", "target")]
train_pred$pred_LR = score_transfer(model = lr_model,
                                                    tbl_woe = train_woe,
                                                    save_data = FALSE)[, "score"]

test_pred$pred_LR = score_transfer(model = lr_model,
tbl_woe = test_woe, save_data = FALSE)[, "score"]
}
