% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{de_one_hot_encoding}
\alias{de_one_hot_encoding}
\title{Recovery One-Hot Encoding}
\usage{
de_one_hot_encoding(dat_one_hot, cat_vars = NULL, na_act = TRUE,
  note = FALSE)
}
\arguments{
\item{dat_one_hot}{A dat frame with the one hot encoding variables}

\item{cat_vars}{variables to be recovery processed, default is null, if null, find these variables through regular expressions .}

\item{na_act}{Logical,If true, the missing value is  assigned as "missing", if FALSE missing value is omitted, the default is TRUE.}

\item{note}{Logical.Outputs info.Default is TRUE.}
}
\value{
A dat frame with the one hot encoding recorery character variables
}
\description{
\code{de_one_hot_encoding} is for one-hot encoding recovery processing
}
\examples{
#one hot encoding
dat1 = one_hot_encoding(dat = UCICreditCard,
cat_vars = c("SEX", "MARRIAGE"),
merge_cat = TRUE, na_act = TRUE)
#de one hot encoding
dat2 = de_one_hot_encoding(dat_one_hot = dat1,
cat_vars = c("SEX","MARRIAGE"),
na_act = FALSE)
}
\seealso{
\code{\link{one_hot_encoding}}
}
