% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_missing_treatment.R
\name{process_outliers}
\alias{process_outliers}
\alias{outliers_kmeans_lof}
\title{Outliers Treatment}
\usage{
process_outliers(dat, target, ex_cols = NULL, kc = 3, kn = 5,
  x_list = NULL, parallel = FALSE, note = FALSE, process = TRUE,
  save_data = FALSE, file_name = NULL, dir_path = tempdir())

outliers_kmeans_lof(dat, x, target = NULL, kc = 3, kn = 5,
  note = FALSE, process = TRUE, save_data = FALSE,
  file_name = NULL, dir_path = tempdir())
}
\arguments{
\item{dat}{Dataset with independent variables and target variable.}

\item{target}{The name of target variable.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{kc}{Number of  clustering centers for Kmeans}

\item{kn}{Number of neighbors for LOF.}

\item{x_list}{Names of independent variables.}

\item{parallel}{Logical, parallel computing.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{process}{Logical, process outliers, not just analysis.}

\item{save_data}{Logical. If TRUE, save outliers analysis file to the specified folder at \code{dir_path}}

\item{file_name}{The file name for periodically saved outliers analysis file. Default is NULL.}

\item{dir_path}{The path for periodically saved outliers analysis file. Default is "./variable".}

\item{x}{The name of variable to process.}
}
\value{
A data frame with outliers process to all the variables.
}
\description{
\code{outliers_kmeans_lof} is for outliers detection and treatment using Kmeans and Local Outlier Factor (lof)
\code{process_outliers} is a simpler wrapper for \code{outliers_kmeans_lof}.
}
\examples{
dat_out = process_outliers(UCICreditCard[1:10000,c(18:21,26)],
                        target = "default.payment.next.month",
                       ex_cols = "date$", kc = 3, kn = 10, 
                       parallel = FALSE,note = TRUE)
}
