% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crev_evrecs.R
\name{crev_evrecs}
\alias{crev_evrecs}
\title{Parse Crossref Events evidence records}
\usage{
crev_evrecs(x, ...)
}
\arguments{
\item{x}{(character) one or more urls for evidence records}

\item{...}{curl options passed through to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
an unnamed list of results, one for each URL passed in.
}
\description{
Parse Crossref Events evidence records
}
\details{
this function doesn't parse results other than converting
JSON to an R list, because the data is deeply nested, so coercing
to data.frame's is an exercise left to the user

From \code{\link[=crev_query]{crev_query()}} you will get  urls like
"https://evidence.eventdata.crossref.org/evidence" in the
\verb{$message$events$evidence_record} slot of results. These links
hold JSON data with the evidence record details for the record. This
function simply retrieves that JSON and parses to a list
}
\examples{
\dontrun{
res <- crev_query(rows = 4)
recs <- res$message$events$evidence_record
crev_evrecs(recs[1])
crev_evrecs(recs)
}
}
