% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller.R
\name{crew_controller}
\alias{crew_controller}
\title{Create a controller object from a client and launcher.}
\usage{
crew_controller(client, launcher, auto_scale = NULL)
}
\arguments{
\item{client}{An \code{R6} client object created by \code{\link[=crew_client]{crew_client()}}.}

\item{launcher}{An \code{R6} launcher object created by one of the
\verb{crew_launcher_*()} functions such as \code{\link[=crew_launcher_local]{crew_launcher_local()}}.}

\item{auto_scale}{Deprecated. Use the \code{scale} argument of \code{push()},
\code{pop()}, and \code{wait()} instead.}
}
\description{
This function is for developers of \code{crew} launcher plugins.
Users should use a specific controller helper such as
\code{\link[=crew_controller_local]{crew_controller_local()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other controller: 
\code{\link{crew_class_controller}}
}
\concept{controller}
