% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_relation.R
\name{sch_all_successors}
\alias{sch_all_successors}
\title{All Successors}
\usage{
sch_all_successors(sch, id, ign_to = NULL)
}
\arguments{
\item{sch}{A schedule object.}

\item{id}{Activity id to be listed.}

\item{ign_to}{A relation to be ignored: id -> ign_to.
Activities from this relation will be ignored.}
}
\value{
A vector with all activities ids.
}
\description{
List all successors from an activity: direct and indirect successors.
}
\examples{
sch <- sch_new() \%>\%
  sch_title("Fictitious Project Example") \%>\%
  sch_reference("VANHOUCKE, Mario. Measuring time:
  improving project performance using earned value management.
  Gent: Springer, 2009, p. 18") \%>\%
  sch_add_activity( 2L, "a2" , 4L,  5L, 12L) \%>\%
  sch_add_activity( 3L, "a3" , 9L, 10L) \%>\%
  sch_add_activity( 4L, "a4" , 1L,  6L) \%>\%
  sch_add_activity( 5L, "a5" , 4L,  9L) \%>\%
  sch_add_activity( 6L, "a6" , 5L,  7L) \%>\%
  sch_add_activity( 7L, "a7" , 1L,  8L,11L) \%>\%
  sch_add_activity( 8L, "a8" , 7L, 12L) \%>\%
  sch_add_activity( 9L, "a9" , 8L, 12L) \%>\%
  sch_add_activity(10L, "a10", 3L, 12L) \%>\%
  sch_add_activity(11L, "a11", 3L, 12L) \%>\%
  sch_add_activity(12L, "a12", 0L) \%>\%
  sch_plan()

sch_all_successors(sch, 2) # 5, 9, 12
sch_all_successors(sch, 7) # 8, 11, 12
sch_all_successors(sch, 10) # 12

}
\seealso{
\code{\link[=sch_predecessors]{sch_predecessors()}}, \code{\link[=sch_activities]{sch_activities()}},
\code{\link[=sch_non_critical_activities]{sch_non_critical_activities()}}, \code{\link[=sch_successors]{sch_successors()}},
\code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_is_redundant]{sch_is_redundant()}}, \code{\link[=sch_all_predecessors]{sch_all_predecessors()}}.
}
