% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestDualEndpoint-class}
\alias{.NextBestDualEndpoint}
\alias{NextBestDualEndpoint-class}
\title{The class with the input for finding the next dose
based on the dual endpoint model}
\description{
This rule first excludes all doses that exceed the probability
\code{maxOverdoseProb} of having an overdose toxicity, as specified by the
overdose interval \code{overdose}. Then, it picks under the remaining
admissible doses the one that maximizes the probability to be in the
\code{target} biomarker range, relative to the maximum biomarker level
across the dose grid or relative to the Emax parameter in case a parametric
model was selected (e.g. \code{\linkS4class{DualEndpointBeta}},
\code{\linkS4class{DualEndpointEmax}}))
}
\section{Slots}{

\describe{
\item{\code{target}}{the biomarker target range, relative to the maximum, that
needs to be reached. For example, (0.8, 1.0) means we target a dose
with at least 80\% of maximum biomarker level. As an other example,
(0.5, 0.8) would mean that we target a dose between 50\% and 80\% of
the maximum biomarker level.}

\item{\code{overdose}}{the overdose toxicity interval (lower limit excluded, upper
limit included)}

\item{\code{maxOverdoseProb}}{maximum overdose probability that is allowed}
}}
\examples{

# Target a dose achieving at least 0.9 of maximum biomarker level (efficacy)
# and with a probability below 0.25 that prob(DLT)>0.35 (safety)

myNextBest <- NextBestDualEndpoint(target=c(0.9, 1),
                                   overdose=c(0.35, 1),
                                   maxOverdoseProb=0.25)


}
\keyword{classes}

