% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingTargetBiomarker-class}
\alias{.StoppingTargetBiomarker}
\alias{StoppingTargetBiomarker-class}
\title{Stop based on probability of target biomarker}
\description{
Stop based on probability of target biomarker
}
\section{Slots}{

\describe{
\item{\code{target}}{the biomarker target range, relative to the maximum, that
needs to be reached. So this must be a probability range (1 is allowed here)}

\item{\code{prob}}{required target probability for reaching sufficient precision}
}}
\examples{
# As example, here is the rule for: 
#   stopping the study if there is at least 0.5 probability that the biomarker 
#   (efficacy) is within the biomarker target range of [0.9, 1.0] (relative to the
#   maximum for the biomarker).

myStopping <- StoppingTargetBiomarker(target = c(0.9, 1),
                                      prob = 0.5)

}
\keyword{classes}

