% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeModel.R
\name{writeModel}
\alias{writeModel}
\title{Creating a WinBUGS model file}
\usage{
writeModel(model, con = "model.bug", digits = 5)
}
\arguments{
\item{model}{R function containing the BUGS model in the BUGS
model language, for minor differences see Section Details.}

\item{con}{passed to \code{\link{writeLines}} which actually writes the
model file}

\item{digits}{number of significant digits used for \pkg{WinBUGS}
input, see \code{\link{formatC}}}
}
\value{
Nothing, but as a side effect, the model file is written
}
\description{
Convert R function to a \pkg{WinBUGS} model file. BUGS models follow
closely S syntax. It is therefore possible to write most BUGS models as R
functions.
As a difference, BUGS syntax allows truncation specification like this:
\code{dnorm(...) I(...)}  but this is illegal in R. To overcome this
incompatibility, use dummy operator \code{\%_\%} before \code{I(...)}:
\code{dnorm(...) \%_\% I(...)}. The dummy operator \code{\%_\%} will be
removed before the BUGS code is saved.
In S-PLUS, a warning is generated when the model function is defined if the
last statement in the model is an assignment. To avoid this warning, add the
line \code{invisible()} to the end of the model definition. This line will be
removed before the BUGS code is saved.
}
\author{
original idea by Jouni Kerman, modified by Uwe Ligges,
Daniel Sabanes Bove removed S-PLUS part
}
