% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{Effloglog-class}
\alias{Effloglog-class}
\alias{.Effloglog}
\alias{Effloglog}
\alias{.DefaultEffloglog}
\title{\code{Effloglog}}
\usage{
Effloglog(eff, eff_dose, nu, data, const = 0)

.DefaultEffloglog()
}
\arguments{
\item{eff}{(\code{numeric})\cr the pseudo efficacy responses.
Elements of \code{eff} must correspond to the elements of \code{eff_dose}.}

\item{eff_dose}{(\code{numeric})\cr dose levels that correspond to pseudo efficacy
responses in \code{eff}.}

\item{nu}{(\code{numeric})\cr the precision (inverse of the variance) of the
efficacy responses. This is either a fixed value or a named vector with two
positive numbers, the shape (\code{a}), and the rate (\code{b}) parameters for the
gamma distribution.}

\item{data}{(\code{DataDual})\cr observed data to update estimates of the model
parameters.}

\item{const}{(\code{number})\cr the constant value added to the dose level when
the dose level value is less than or equal to 1 and a special form of the
linear log-log has to be applied
\insertCite{YeungWhiteheadReignerBeyerDiackJaki2015}{crmPack}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{Effloglog}} is the class for the linear log-log efficacy model using pseudo
data prior. It describes the relationship between continuous efficacy
responses and corresponding dose levels in log-log scale. This efficacy
log-log model is given as
\deqn{y_i = theta1 + theta2 * log(log(x_i)) + epsilon_i,}
where \eqn{y_i} is the efficacy response for subject \eqn{i}, \eqn{x_i} is
the dose level treated for subject \eqn{i} and \eqn{epsilon_i} is the random
error term of efficacy model at subject \eqn{i}. The error term
\eqn{epsilon_i} is a random variable that follows normal distribution with
mean \eqn{0} and variance \eqn{nu^{-1}}, which is assumed to be the
same for all subjects.
There are three parameters in this model, the intercept \eqn{theta1}, the
slope \eqn{theta2} and the precision \eqn{nu} of the efficacy responses, also
known as the inverse of the variance of the pseudo efficacy responses. It can
be a fixed constant or having a gamma distribution. Therefore, a single scalar
value or a vector with two positive numbers values must be specified for \code{nu}
slot. If there are some observed efficacy responses available, in the output,
\code{nu} will display the updated value of the precision or the updated values
for the parameters of the gamma distribution.
The \code{Effloglog} inherits all slots from \code{\link{ModelEff}} class.
}
\details{
The prior of this model is specified in form of pseudo data. First,
at least two dose levels are fixed. Then, using e.g. experts' opinion, the
efficacy values that correspond to these dose levels can be obtained,
The \code{eff} and \code{eff_dose} arguments represent the prior in form of the pseudo
data. The \code{eff} represents the pseudo efficacy values. The \code{eff_dose}
represents the dose levels at which these pseudo efficacy values are
observed. Hence, the positions of the elements specified in \code{eff} and
\code{eff_dose} must correspond to each other between these vectors.
Since at least 2 pseudo efficacy values are needed to obtain modal
estimates of the intercept and slope parameters, both \code{eff} and \code{eff_dose}
must be vectors of length at least 2.

The joint prior distribution of the intercept \eqn{theta1} and the slope
\eqn{theta2} of this model follows bivariate normal distribution with mean
\eqn{mu} and covariance matrix \eqn{(nu * Q)^{-1}}.
The mean \eqn{mu} is a \eqn{2 x 1} column vector that contains the prior
modal estimates of the intercept and the slope.
Scalar \eqn{nu} is the precision of the pseudo efficacy responses and
\eqn{Q} is the prior or posterior (given that observed, no DLT data is
available) precision matrix.
It is specified as \eqn{Q = X0^T * X0 + X^T * X}, where \eqn{X0} is a
design matrix that is based on pseudo dose levels only, and \eqn{X} is a
design matrix that is based on dose levels corresponding to the no DLT
efficacy responses observed only (if any).
Hence, the \eqn{X0} (or \eqn{X}) will be of size \eqn{r x 2}, if
there are \eqn{r >= 2} pseudo efficacy responses specified (or
if there are \eqn{r} no DLT efficacy responses observed in the \code{data}).
}
\section{Slots}{

\describe{
\item{\code{eff}}{(\code{numeric})\cr the pseudo efficacy responses. Each element here
must represent responses treated based on one subject.
It must be a vector of length at least 2 and the order of its elements must
correspond to values specified in \code{eff_dose}.}

\item{\code{eff_dose}}{(\code{numeric})\cr the pseudo efficacy dose levels at which the
pseudo efficacy responses are observed.
It must be a vector of length at least 2 and the order of its elements must
correspond to values specified in \code{eff}.}

\item{\code{nu}}{(\code{numeric})\cr parameter of the prior precision of pseudo efficacy
responses. This is either a fixed value or a named vector with two positive
numbers, the shape (\code{a}), and the rate (\code{b}) parameters for the gamma
distribution.}

\item{\code{use_fixed}}{(\code{flag})\cr indicates whether \code{nu} specified is a fixed value
or a vector with two parameters for gamma distribution. This slot is for
internal purposes only and must not be used by the user.}

\item{\code{theta1}}{(\code{number})\cr the intercept in this efficacy log-log model. This
slot is used in output to display the resulting prior or posterior modal
estimates obtained based on the pseudo and observed (if any) data.}

\item{\code{theta2}}{(\code{number})\cr the slope in this efficacy log-log model. This
slot is used in output to display the resulting prior or posterior modal
estimates obtained based on the pseudo and observed (if any) data.}

\item{\code{Pcov}}{(\code{matrix})\cr refers to the \eqn{2 x 2} covariance matrix of the
estimators of the intercept \eqn{theta1} and the slope \eqn{theta2}
parameters in this model.
This is used in output to display the resulting prior and posterior
covariance matrix of \eqn{theta1} and \eqn{theta2} obtained, based on the
pseudo and observed (if any) data. This slot is needed for internal purposes.}

\item{\code{X}}{(\code{matrix})\cr is the design matrix that is based on either the pseudo
dose levels or observed dose levels (without DLT). This is used
in the output to display the design matrix for the pseudo or the observed
efficacy responses.}

\item{\code{Y}}{(\code{numeric})\cr is a vector that either contains the pseudo efficacy
responses or observed efficacy responses (without DLT).}

\item{\code{mu}}{(\code{numeric})\cr a vector of the prior or the posterior modal estimates
of the intercept (\eqn{theta1}) and the slope (\eqn{theta2}).
This slot is used in output to display as the mean of the prior or posterior
bivariate normal distribution for \eqn{theta1} and \eqn{theta2}.}

\item{\code{Q}}{(\code{matrix})\cr is the prior or posterior (given that observed, no DLT
data is available) precision matrix. It is specified as
\eqn{Q = X0^T * X0 + X^T * X}, where \eqn{X0} is a design matrix that is
based on pseudo dose levels only, and \eqn{X} is a design matrix that is
based on dose levels corresponding to the observed, no DLT efficacy values
only (if any).}

\item{\code{const}}{(\code{number})\cr a non-negative number (default to 0), leading to the
model form described above. In general, the model has the form
\eqn{y_i = theta1 + theta2 * log(log(x_i + const)) + epsilon_i}, such that
dose levels greater than \eqn{1 - const} can be considered as described in
\insertCite{YeungWhiteheadReignerBeyerDiackJaki2015;textual}{crmPack}.}
}}

\note{
Typically, end users will not use the \code{.DefaultEffloglog()} function.
}
\examples{
# Obtain prior modal estimates given the pseudo data.
# First we use an empty data set such that only the dose levels under
# investigations are given. In total, 12 dose levels are under investigation
# ranging from 25 to 300 mg with increments of 25 (i.e 25, 50, 75, ..., 300).
emptydata <- DataDual(doseGrid = seq(25, 300, 25), placebo = FALSE)

# Define the pseudo data as first by fixing two dose levels 25 and 300 mg (`eff_dose`).
# Then, the efficacy responses observed at these two dose levels are 1.223 and 2.513 (`eff`).
# We specify the prior precision of the pseudo efficacy responses (`nu`) as a vector
# with the shape (a) and the rate (b) parameters for the gamma distribution.
# Obtain modal estimates and other estimates from the model (no observations,
# only pseudo data).
my_model1 <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = emptydata
)

# Observed data.
my_data <- DataDual(
  x = c(25, 50, 50, 75, 100, 100, 225, 300),
  y = c(0, 0, 0, 0, 1, 1, 1, 1),
  w = c(0.31, 0.42, 0.59, 0.45, 0.6, 0.7, 0.6, 0.52),
  doseGrid = emptydata@doseGrid
)

# Obtain posterior modal estimates and other estimates from the model given some
# observed data.
my_model2 <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = my_data
)
}
\references{
\insertAllCited{}
}
