% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingCohortsNearDose-class}
\alias{StoppingCohortsNearDose-class}
\alias{.StoppingCohortsNearDose}
\alias{StoppingCohortsNearDose}
\alias{.DefaultStoppingCohortsNearDose}
\title{\code{StoppingCohortsNearDose}}
\usage{
StoppingCohortsNearDose(
  nCohorts = 2L,
  percentage = 50,
  report_label = NA_character_
)

.DefaultStoppingCohortsNearDose()
}
\arguments{
\item{nCohorts}{(\code{number})\cr see slot definition.}

\item{percentage}{(\code{number})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{StoppingCohortsNearDose}} is the class for stopping based on number of
cohorts near to next best dose.
}
\section{Slots}{

\describe{
\item{\code{nCohorts}}{(\code{number})\cr number of required cohorts.}

\item{\code{percentage}}{(\code{number})\cr percentage (between and including 0 and 100)
within the next best dose the cohorts must lie.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingCohortsNearDose()} function.
}
\examples{
# Here, is the rule for stopping the study if at least 3 cohorts were dosed
# at a dose within (1 +/- 0.2) of the next best dose.
my_stopping <- StoppingCohortsNearDose(
  nCohorts = 3,
  percentage = 0.2
)
}
