% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration_ppt_etp.R
\name{ppt_calibration}
\alias{ppt_calibration}
\title{Calibration of rainfall (ppt) of 'TerraClimate'
\if{html}{\figure{logo_cropDemand.png}{options: height= 300 width=auto style = float:right alt= Our logo}}}
\usage{
ppt_calibration(slope, intercept, ppt_stack)
}
\arguments{
\item{slope}{the slope of the linear regression (numeric).}

\item{intercept}{the intercept of the linear regression (numeric).}

\item{ppt_stack}{stack of ppt.}
}
\value{
Returns a Rasterstack of ppt calibrated.
}
\description{
This fuction will calibrate the rainfall (ppt) from TerraClimate dataset based in the relationship with observed weather stations data.
}
\examples{
\dontrun{

ppt_cal<- ppt_calibration(slope = 0.7000972,
                          intercept = 23.753785, ppt_stack = ppt);
}
}
