% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.crossnma.model.R
\name{summary.crossnma.model}
\alias{summary.crossnma.model}
\title{Summary function for crossnma.model object}
\usage{
\method{summary}{crossnma.model}(object, ...)
}
\arguments{
\item{object}{An object generated by the
\code{\link{crossnma.model}}.}

\item{\dots}{Additional arguments (ignored)}
}
\value{
An object of classes \code{summary.crossnma.model} and
\code{crossnma.model} containing information on the JAGS model,
which is a list containing the following components:

\item{model}{A long character string containing JAGS code that
  will be run in \code{\link[rjags]{jags.model}}.}
\item{data}{The data to be used to run JAGS model.}
\item{trt.key}{A table of the treatments and its mapped integer
  number (as used in JAGS model).}
\item{study.key}{A table of the studies and its mapped integer
  number (as used in JAGS model).}
\item{trt.effect}{A character defining the model for the
  study-specific treatment effects.}
\item{method.bias}{A character for defining the method to combine
  randomized clinical trials (RCT) and non-randomized studies
  (NRS).}
\item{covariate}{A vector of the the names of the covariates
  (\code{cov1, cov2 and cov3}) in prt.data and std.data used in
  network meta-regression.}
\item{cov.ref}{A vector of values of \code{cov1.ref, cov2.ref,
  cov3.ref} to center continuous covariates. Dichotomous covariates
  take NA.}
\item{dich.cov.labels}{A matrix with the levels of each dichotomous
  covariate and the corresponding assigned 0 / 1 values.}
\item{split.regcoef}{A logical value. If FALSE the within- and
  between-study regression coefficients will be considered equal.}
\item{regb.effect}{A character indicating the model for the
  between-study regression coefficients across studies.}
\item{regw.effect}{A character indicating the model for the
  within-study regression coefficients across studies.}
\item{bias.effect}{A character indicating the model for the bias
  coefficients across studies.}
\item{bias.type}{A character indicating the effect of bias on the
  treatment effect; additive ('add') or multiplicative ('mult') or
  both ('both').}
\item{all.data.ad}{A data.frame object with the prt.data (after it
  is aggregated) and std.data in a single dataset.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{crossnma} used to create
  object.}
}
\description{
Summary function for crossnma.model object
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")
summary(mod)

}
\seealso{
\code{\link{print.summary.crossnma.model}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
