% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.r
\name{exactbin}
\alias{exactbin}
\title{Exact Joint Probabilities for Low n}
\usage{
exactbin(n, p = 0.5, prec = 120)
}
\arguments{
\item{n}{number, length of seqience, at most 6.}

\item{p}{success probability.}

\item{prec}{precision in mpfr calculations.
Default 120.}
}
\value{
mpfr array
}
\description{
Exact joint probabilities, for low n,
of the number of crossings C and the longest run L
in n independent Bernoulli observations with success
probability p. Probabilites are multiplied by \eqn{2^{n-1}}.
}
\examples{
exactbin(n=6)
exactbin(n=5, p=0.6)
}
