% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_crosstable}
\alias{body_add_crosstable}
\title{Add a crosstable to an \code{officer} document}
\usage{
body_add_crosstable(
  doc,
  x,
  body_fontsize = NULL,
  header_fontsize = ceiling(body_fontsize * 1.2),
  padding_v = NULL,
  allow_break = TRUE,
  max_cols = 25,
  ...
)
}
\arguments{
\item{doc}{a \code{rdocx} object, created by \code{\link[officer:read_docx]{officer::read_docx()}}}

\item{x}{a \code{crosstable} object}

\item{body_fontsize}{fontsize of the body}

\item{header_fontsize}{fontsize of the header}

\item{padding_v}{vertical padding of all table rows}

\item{allow_break}{allow crosstable rows to break across pages}

\item{max_cols}{max number of columns for \code{x}}

\item{...}{further arguments passed to \code{\link[=as_flextable.crosstable]{as_flextable.crosstable()}}}
}
\value{
The docx object \code{doc}
}
\description{
\code{\link[=body_add_crosstable]{body_add_crosstable()}} adds such a \code{flextable} an \code{officer} document.
}
\examples{
#Officer
library(officer)
mytable = crosstable(mtcars2)
doc = read_docx() \%>\%
    body_add_crosstable(mytable) \%>\%
    body_add_break \%>\%
    body_add_crosstable(mytable, compact=TRUE)

dfile = tempfile(fileext=".docx")
print(doc, target = dfile)
if(interactive()) browseURL(dfile)
}
\author{
Dan Chaltiel
}
