% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect}
\alias{collect}
\alias{collect.CrunchDataset}
\alias{collect.GroupedCrunchDataset}
\title{Collect a Crunch dataset from the server}
\usage{
\method{collect}{CrunchDataset}(x, ...)

\method{collect}{GroupedCrunchDataset}(x, ...)
}
\arguments{
\item{x}{A Crunch Dataset}

\item{...}{Other arguments passed to \code{crunch::as.data.frame()}}
}
\value{
A \code{tbl_df} or \code{grouped_df}
}
\description{
This function brings a Crunch dataset into memory so that you can
work with the data using R functions. Since this can create a long running
query it is recommended that you try to filter the dataset down as much as possible
before running \code{collect()}.
}
\details{
When collecting a grouped CrunchDataset, the grouping will be preserved.
}
\examples{
\dontrun{
ds \%>\%
   group_by(cyl) \%>\%
   select(cyl, gear) \%>\%
   collect()
}
}
