% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-by.R
\name{group_by}
\alias{group_by}
\alias{group_by.CrunchDataset}
\alias{ungroup.CrunchDataset}
\title{Group-by for Crunch datasets}
\usage{
\method{group_by}{CrunchDataset}(.data, ..., add = FALSE)

\method{ungroup}{CrunchDataset}(x, ...)
}
\arguments{
\item{.data}{For \code{group_by()}, a Crunch Dataset}

\item{...}{references to variables to group by, passed to
\code{\link[dplyr:group_by_prepare]{dplyr::group_by_prepare()}}}

\item{add}{Logical: add the variables in \code{...} to any existing grouping
variables, or replace them (the default).}

\item{x}{For \code{ungroup()}, a Crunch Dataset}
}
\value{
\code{group_by()} returns a \code{GroupedCrunchDataset} object (a
\code{CrunchDataset} with grouping annotations). \code{ungroup()} returns a
\code{CrunchDataset}.
}
\description{
\code{group_by()} sets grouping variables that affect what \code{\link[=summarize]{summarize()}} computes.
\code{ungroup()} removes any grouping variables.
}
\details{
Note that \code{group_by()} only supports grouping on variables that exist in the
dataset, not ones that are derived on the fly. \code{dplyr::group_by()} supports
that by calling \code{mutate()} internally, but \code{mutate} is not yet supported in
\code{crplyr}.
}
\examples{
\dontrun{
ds \%>\%
   group_by(cyl) \%>\%
   select(cyl, gear) \%>\%
   collect()
}
}
