% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter}
\alias{filter}
\alias{filter.CrunchDataset}
\title{Filter a Crunch dataset}
\usage{
\method{filter}{CrunchDataset}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{CrunchDataset}}

\item{...}{filter expressions}

\item{.preserve}{Relevant when the \code{.data} input is grouped. If
\code{.presrve = FALSE} (the default), the grouping structure is recalculated
based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
\code{.data} with the filter expressions applied.
}
\description{
This function applies a \code{CrunchLogicalExpression} filter to a
\code{CrunchDataset}. It's a "tidy" way of doing \code{ds[ds$var == val,]}.
}
\examples{
\dontrun{
ds \%>\%
   select(cyl, gear) \%>\%
   filter(cyl > 4) \%>\%
   collect()
}
}
