% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_helpers.R
\name{na_count}
\alias{na_count}
\alias{na_count.data.frame}
\alias{na_count.default}
\title{Count the number of NAs in an object}
\usage{
na_count(x, ...)

\method{na_count}{data.frame}(x, columns = c(), ...)

\method{na_count}{default}(x, ...)
}
\arguments{
\item{x}{An object, either a vector or a data.frame}

\item{...}{Extra arguments to na_count}

\item{columns}{Vector of column names}
}
\description{
Count the number of NAs in an object
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: If columns are specified, returns the maximum of the count of NAs for those columns. Otherwise, it returns the number of rows that have a NA in any column.

\item \code{default}: Calls \code{\link{na.omit}} on \code{x}, and returns the length of the result. This is only meaningful for one-dimensional objects (vectors).
}}

