% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-subset.R
\name{skipMissingCategories}
\alias{skipMissingCategories}
\title{Handle missing categories in CrunchCube}
\usage{
skipMissingCategories(cube, index)
}
\arguments{
\item{cube}{a CrunchCube}

\item{index}{a index of the real cube which was generated by
\code{translateCubeIndex()}}
}
\value{
A list of logical vectors
}
\description{
By default we don't display missing categories. The result is that when the
user subsets a cube with a missing category, we need to translate that subset
to only refer to the non-missing categories. This occurs if \code{cube@useNA} is
set to \code{"no"}. It can also occur if \code{useNA = "ifAny"} and there are no non-0
missing categories This function handles this behavior by translating the
user supplied indices to logical vectors which accounts for the missing
values.
}
\keyword{internal}
