% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-calculate.R
\name{calcTransforms}
\alias{calcTransforms}
\title{Calculate transforms for an array}
\usage{
calcTransforms(array, trans, var_cats, include = c("subtotals", "headings",
  "cube_cells", "other_insertions"))
}
\arguments{
\item{array}{the array to use (this is most likely from a \code{CrunchCube`` object). The cells from this array are the cube_cells referred to in}include`}

\item{trans}{a \code{Transform} object to get the transformations to calculate}

\item{var_cats}{a \code{Categories} object that are the categories for the
variable the transforms are being calculated for}

\item{include}{what values should be included in the output? (default: "subtotals", "headings", "cube_cells", "other_insertions")
\itemize{
\item cube_cells -- the values from the array given in \code{array}
\item subtotals -- insertions that have the function subtotal
\item headings -- insertions that have no function specified
\item other_insertions -- any other insertion that is present in the transforms
}}
}
\value{
an array with transforms calculated and added or applied
}
\description{
Given an array and transforms calculate values based on the transforms and
then return the values calculated that are specified.
}
\keyword{internal}
