% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Categories-class}
\alias{Categories-class}
\alias{Categories}
\alias{Category-class}
\alias{Category}
\title{Categories in CategoricalVariables}
\usage{
Categories(..., data = NULL)

Category(..., data = NULL)
}
\arguments{
\item{...}{Category attributes}

\item{data}{For the constructor functions \code{Category} and
\code{Categories}, you can either pass in attributes via \code{...} or you
can create the objects with a fully defined \code{list} representation of
the objects via the \code{data} argument. See the examples.}
}
\description{
CategoricalVariables, as well as the array types composed from
Categoricals, contain Categories. Categories are a subclass of list that
contains only Category objects. Category objects are themselves subclasses of
lists and contain the following fields: "name", "id", "numeric_value",
"missing", and optionally "selected".
}
\examples{
cat.a <- Category(name="First", id=1, numeric_value=1, missing=FALSE)
cat.b <- Category(data=list(name="First", id=1, numeric_value=1, missing=FALSE))
identical(cat.a, cat.b)
cat.c <- Category(name="Second", id=2)
cats.1 <- Categories(cat.a, cat.c)
cats.2 <- Categories(data=list(cat.a, cat.c))
identical(cats.1, cats.2)
}
