% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-array.R
\name{deriveArray}
\alias{deriveArray}
\alias{makeArray}
\alias{makeMR}
\title{Make a Categorical Array or Multiple Response variable}
\usage{
deriveArray(subvariables, name, selections, numeric = NULL, ...)

makeArray(subvariables, name, ...)

makeMR(subvariables, name, selections, ...)
}
\arguments{
\item{subvariables}{a list of Variable objects to bind together, or a
Dataset subset which contains only the Variables to bind.}

\item{name}{character, the name that the new Categorical Array variable
should have.}

\item{selections}{character, for \code{makeMR} and \code{deriveArray} the names of the
categories to mark as the dichotomous selections. Required for
\code{makeMR}; optional for \code{deriveArray}; ignored in \code{makeArray}.}

\item{numeric}{Logical indicating whether the array should be a numeric
array or categorical array. \code{NULL} the default will guess numeric if
all variables are known to be numeric and categorical if all are
categorical. If any subvariables are created from expressions, then
their type cannot be guessed and so \code{numeric} must be specified.}

\item{...}{Optional additional attributes to set on the new variable.}
}
\value{
A VariableDefinition that when added to a Dataset will create the
categorical-array or multiple-response variable. \code{deriveArray} will
make a derived array expression (or a derived multiple response expression
if \code{selections} are supplied), while \code{makeArray} and \code{makeMR}
return an expression that "binds" variables together, removing them from
independent existence.
}
\description{
In most situations we recommend using \code{deriveArray} which leaves your
subvariables in the dataset. \code{makeArray} \emph{removes} component subvariables
from your dataset. Array variables are composed of a set of "subvariables"
bound together for display  in the app. For example, you might have a set of
survey questions that ask how the respondent would rate a TV show from 1-5.
Array variables allow you to display all of their ratings in a compact table
rather than a set of distinct variables.
}
