% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{settings}
\alias{settings}
\alias{settings<-}
\title{View and modify dataset-level settings}
\usage{
settings(x)

settings(x) <- value
}
\arguments{
\item{x}{CrunchDataset}

\item{value}{A settings object (\code{ShojiEntity}), for the setter}
}
\value{
The getter returns a settings object (\code{ShojiEntity}). The setter
returns the dataset (\code{x}), duly modified.
}
\description{
These methods allow access and control over dataset settings. Currently
supported settings include:
\itemize{
\item User Authorizations for view-only users ('viewers_can_export', 'viewers_can_share', and
'viewers_can_change_weight'); and
\item 'weight', which determines the default weighting variable for the dataset
Additional settings will be added in the future. See
https://crunch.io/api/reference/#post-/datasets/
-> request body model -> settings key, for an up-to-date
list of settings supported throughout the Crunch system. Clients may also
provide and use custom settings if they choose.
}
}
\examples{
\dontrun{
settings(ds)
settings(ds)$viewers_can_export <- TRUE
settings(ds)$weight <- ds$myWeightVariable
}
}
