% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-dataset.R
\name{exportDataset}
\alias{exportDataset}
\alias{write.csv}
\alias{write.csv,CrunchDataset-method}
\title{Export a dataset to a file}
\usage{
exportDataset(
  dataset,
  file,
  format = c("csv", "spss", "parquet"),
  categorical = c("name", "id"),
  na = NULL,
  varlabel = c("name", "description"),
  include.hidden = FALSE,
  ...
)

\S4method{write.csv}{CrunchDataset}(x, ...)
}
\arguments{
\item{dataset}{CrunchDataset, which may have been subsetted with a filter
expression on the rows and a selection of variables on the columns.}

\item{file}{character local filename to write to}

\item{format}{character export format: currently supported values are "csv"
and "spss" (and experimental support for "parquet").}

\item{categorical}{character: export categorical values to CSV as category
"name" (default) or "id". Ignored by the SPSS exporter.}

\item{na}{Similar to the argument in \code{\link[utils:write.table]{utils::write.table()}}, 'na'
lets you control how missing values are written into the CSV file.
Supported values are:
\enumerate{
\item \code{NULL}, the default, which means that
categorical variables will have the category name or id as the value, and
numeric, text, and datetime variables will have the missing reason string;
\item A string to use for missing values.
\item \code{""} means that empty cells will be written for missing values for all types.
}}

\item{varlabel}{For SPSS export, which Crunch metadata field should be used
as variable labels? Default is "name", but "description" is another valid
value.}

\item{include.hidden}{logical: should hidden variables be included? (default: \code{FALSE})}

\item{...}{additional options. See the API documentation. Currently supported
boolean options include 'include_personal' for personal variables (default:
\code{FALSE}) and 'prefix_subvariables' for SPSS format: whether to include
the array variable's name in each of its subvariables "varlabels" (default:
\code{FALSE}).}

\item{x}{(for write.csv) CrunchDataset, which may have been subsetted with a filter
expression on the rows and a selection of variables on the columns.}
}
\value{
Invisibly, \code{file}.
}
\description{
This function allows you to write a CrunchDataset to a .csv or SPSS .sav file.
}
\examples{
\dontrun{
csv_file <- exportDataset(ds, "data.csv")
data <- read.csv(csv_file)

# parquet will likely read more quickly and be a smaller download size
parquet_file <- exportDataset(ds, "data.parquet")
# data <- arrow::read_parquet(parquet_file) # The arrow package can read parquet files
}
}
