% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_exchanges.R
\name{crypto_exchanges}
\alias{crypto_exchanges}
\title{Get current crypto market exchanges}
\usage{
crypto_exchanges(coin = NULL, limit = NULL, start_date = NULL,
  end_date = NULL, sleep = NULL)
}
\arguments{
\item{coin}{string Name, symbol or slug of crypto currency, default is all tokens}

\item{limit}{integer Return the top n records, default is all tokens}

\item{start_date}{string Start date to retrieve data from, format 'yyyymmdd'}

\item{end_date}{string End date to retrieve data from, format 'yyyymmdd'}

\item{sleep}{integer Seconds to sleep for between API requests}
}
\value{
Crypto currency historic OHLC market data in a dataframe:
  \item{slug}{Coin url slug}
  \item{symbol}{Coin symbol}
  \item{name}{Coin name}
  \item{trading_pair}{Coin trading pair}
  \item{exchange_name}{Name of exchange}
  \item{last_updated}{Exchange refresh}
  \item{exchange_volume}{Exchange $USD volume}
  \item{exchange_price}{Exchange $USD price}
  \item{exchange_share}{Percent exchange traded}
  \item{coin_rank}{Rank of current coin}
  \item{exchange_rank}{Exchange ranking for coin}
If you want to retrieve ALL coins and their exchanges,
then do not pass a argument to crypto_exchanges(),
}
\description{
Scrape the crypto currency exchange tables from
CoinMarketCap <https://coinmarketcap.com> and display
the results in a date frame. This can be used to conduct
analysis on the exchanges or to attempt
to predict exchange arbiture.
}
\examples{
\dontrun{
# Retrieving exchange data for specific crypto currency

coin <- 'kin'
kin_exchanges <- crypto_exchanges(coin)

# retrieving market history for ALL crypto currencies

all_exchanges <- crypto_exchanges()

}
}
