/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CoordinateArrays {
    private static final CGAlgorithms cga = new RobustCGAlgorithms();
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate[] toCoordinateArray(List coordList) {
        return coordList.toArray(coordArrayType);
    }

    public static void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
        }
    }

    public static Geometry toLineOrPoint(Coordinate[] coords, GeometryFactory fact) {
        if (coords.length > 1) {
            return fact.createLineString(coords);
        }
        if (coords.length == 1) {
            return fact.createPoint(coords[0]);
        }
        return fact.createPoint((Coordinate)null);
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coord1[i].equals((Object)coord2[i])) continue;
            return false;
        }
        return true;
    }

    public static List fromCoordinateArrays(List coordArrays, GeometryFactory fact) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        Iterator i = coordArrays.iterator();
        while (i.hasNext()) {
            Coordinate[] coords = (Coordinate[])i.next();
            Geometry geom = CoordinateArrays.toLineOrPoint(coords, fact);
            geomList.add(geom);
        }
        return geomList;
    }

    public static void addCoordinateArrays(Geometry g, boolean orientPolygons, List coordArrayList) {
        if (g.getDimension() <= 0) {
            return;
        }
        if (g instanceof LineString) {
            LineString l = (LineString)g;
            coordArrayList.add(l.getCoordinates());
        } else if (g instanceof Polygon) {
            Polygon poly = (Polygon)g;
            Coordinate[] shell = poly.getExteriorRing().getCoordinates();
            if (orientPolygons) {
                shell = CoordinateArrays.ensureOrientation(shell, -1);
            }
            coordArrayList.add(shell);
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                Coordinate[] hole = poly.getInteriorRingN(i).getCoordinates();
                if (orientPolygons) {
                    hole = CoordinateArrays.ensureOrientation(hole, 1);
                }
                coordArrayList.add(hole);
            }
        } else if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                CoordinateArrays.addCoordinateArrays(gc.getGeometryN(i), orientPolygons, coordArrayList);
            }
        } else {
            Assert.shouldNeverReachHere((String)("Geometry of type " + g.getClass().getName() + " not handled"));
        }
    }

    public static Coordinate[] ensureOrientation(Coordinate[] coord, int desiredOrientation) {
        int orientation;
        if (coord.length == 0) {
            return coord;
        }
        int n = orientation = CGAlgorithms.isCCW((Coordinate[])coord) ? 1 : -1;
        if (orientation != desiredOrientation) {
            Coordinate[] reverse = (Coordinate[])coord.clone();
            CoordinateArrays.reverse(reverse);
            return reverse;
        }
        return coord;
    }

    public static List toCoordinateArrays(Geometry g, boolean orientPolygons) {
        ArrayList coordArrayList = new ArrayList();
        CoordinateArrays.addCoordinateArrays(g, orientPolygons, coordArrayList);
        return coordArrayList;
    }
}

