/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dbffile;

import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.geotools.dbffile.DbfConsts;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFileException;
import org.geotools.misc.FormatedString;

public class DbfFileWriter
implements DbfConsts {
    private static final boolean DEBUG = false;
    private static final String DBC = "DbFW>";
    int NoFields = 1;
    int NoRecs = 0;
    int recLength = 0;
    DbfFieldDef[] fields;
    EndianDataOutputStream ls;
    private boolean header = false;
    int dp = 2;

    public DbfFileWriter(String file) throws IOException {
        this.ls = new EndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public void writeHeader(DbfFieldDef[] f, int nrecs) throws IOException {
        int i;
        this.NoFields = f.length;
        this.NoRecs = nrecs;
        this.fields = new DbfFieldDef[this.NoFields];
        for (int i2 = 0; i2 < this.NoFields; ++i2) {
            this.fields[i2] = f[i2];
        }
        this.ls.writeByteLE(3);
        GregorianCalendar calendar = new GregorianCalendar();
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        this.ls.writeByteLE(calendar.get(1) - 1900);
        this.ls.writeByteLE(calendar.get(2) + 1);
        this.ls.writeByteLE(calendar.get(5));
        int dataOffset = 32 * this.NoFields + 32 + 1;
        for (i = 0; i < this.NoFields; ++i) {
            this.recLength += this.fields[i].fieldlen;
        }
        ++this.recLength;
        this.ls.writeIntLE(this.NoRecs);
        this.ls.writeShortLE(dataOffset);
        this.ls.writeShortLE(this.recLength);
        for (i = 0; i < 20; ++i) {
            this.ls.writeByteLE(0);
        }
        for (i = 0; i < this.NoFields; ++i) {
            int j;
            this.ls.writeBytesLE(this.fields[i].fieldname.toString());
            this.ls.writeByteLE(this.fields[i].fieldtype);
            for (j = 0; j < 4; ++j) {
                this.ls.writeByteLE(0);
            }
            this.ls.writeByteLE(this.fields[i].fieldlen);
            this.ls.writeByteLE(this.fields[i].fieldnumdec);
            for (j = 0; j < 14; ++j) {
                this.ls.writeByteLE(0);
            }
        }
        this.ls.writeByteLE(13);
        this.header = true;
    }

    public void writeRecords(Vector[] recs) throws DbfFileException, IOException {
        if (!this.header) {
            throw new DbfFileException("Must write header before records");
        }
        int i = 0;
        try {
            for (i = 0; i < recs.length; ++i) {
                if (recs[i].size() != this.NoFields) {
                    throw new DbfFileException("wrong number of records in " + i + "th record " + recs[i].size() + " expected " + this.NoFields);
                }
                this.writeRecord(recs[i]);
            }
        }
        catch (DbfFileException e) {
            throw new DbfFileException("DbFW>at rec " + i + "\n" + e);
        }
    }

    public void writeRecord(Vector rec) throws DbfFileException, IOException {
        if (!this.header) {
            throw new DbfFileException("DbFW>Must write header before records");
        }
        if (rec.size() != this.NoFields) {
            throw new DbfFileException("DbFW>wrong number of fields " + rec.size() + " expected " + this.NoFields);
        }
        this.ls.writeByteLE(32);
        block5: for (int i = 0; i < this.NoFields; ++i) {
            int len = this.fields[i].fieldlen;
            Object o = rec.elementAt(i);
            switch (this.fields[i].fieldtype) {
                case 'C': 
                case 'D': 
                case 'G': 
                case 'L': 
                case 'M': 
                case 'c': {
                    String ss = (String)o;
                    while (ss.length() < this.fields[i].fieldlen) {
                        ss = ss + "                                                                                                                  ";
                    }
                    StringBuffer tmps = new StringBuffer(ss);
                    tmps.setLength(this.fields[i].fieldlen);
                    this.ls.writeBytesLE(tmps.toString());
                    continue block5;
                }
                case 'N': 
                case 'n': {
                    if (this.fields[i].fieldnumdec == 0) {
                        this.ls.writeBytesLE(FormatedString.format((Integer)o, this.fields[i].fieldlen));
                        continue block5;
                    }
                }
                case 'F': 
                case 'f': {
                    String s = ((Double)o).toString();
                    String x = FormatedString.format(s, this.fields[i].fieldnumdec, this.fields[i].fieldlen);
                    this.ls.writeBytesLE(x);
                }
            }
        }
    }

    public void close() throws IOException {
        this.ls.writeByteLE(26);
        this.ls.close();
    }
}

