% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_csvy.R
\name{write_csvy}
\alias{write_csvy}
\title{Export CSVY data}
\usage{
write_csvy(x, file = "", sep = ",", sep2 = ".", comment_header = TRUE,
  ...)
}
\arguments{
\item{x}{A data.frame.}

\item{file}{A character string or R connection specifying a file.}

\item{sep}{A character string specifying a between-field separator. Passed to \code{\link[utils]{write.table}}.}

\item{sep2}{A character string specifying a within-field separator. Passed to \code{\link[utils]{write.table}}.}

\item{comment_header}{A logical indicating whether to comment the lines containing the YAML front matter. Default is \code{TRUE}.}

\item{\dots}{Additional arguments passed to \code{\link[utils]{write.table}}.}
}
\description{
Export data.frame to CSVY
}
\examples{
library("datasets")
write_csvy(head(iris))

# write yaml w/o comment charaters
write_csvy(head(iris), comment_header = FALSE)

}
\seealso{
\code{\link{write_csvy}}
}

