% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_mutations.R
\name{filter_mutations}
\alias{filter_mutations}
\title{Filters a set of mutations}
\usage{
filter_mutations(mutations, bams = NULL, black_list = NULL,
  tags = rep("", length(bams)), min_alt_reads = 2, min_samples = 2,
  min_base_quality = 20, max_depth = 1e+05, min_mapq = 30,
  substitution_specific = TRUE)
}
\arguments{
\item{mutations}{A data frame with the reporter mutations. Should have the columns CHROM, POS, REF, ALT.}

\item{bams}{a vector of paths to bam files}

\item{black_list}{a character vector of genomic loci of format chr_pos to filter. If not given, the bams
will be scanned for mismatches in the mutations loci and the specified thresholds will be applied for filtering.}

\item{tags}{a vector of the RG tags if the bam has more than one sample}

\item{min_alt_reads}{the threshold of read counts showing alternative allele for a sample to be counted}

\item{min_samples}{the threshold of number of samples above which the mutations is filtered}

\item{min_base_quality}{minimum base quality for a read to be counted}

\item{max_depth}{maximum depth above which sampling will happen}

\item{min_mapq}{the minimum mapping quality for a read to be counted}

\item{substitution_specific}{logical, whether to have the loci of black_list by substitutions.}
}
\value{
a named list contains:
 \itemize{
  \item ref: vector of read counts of the reference alleles
  \item alt: vector of read counts of the alternative allele
}
}
\description{
This function Filters a set of mutations given the input black list or the prevalence of their mismatches in a set of bam files. Mutations that
have more than min_alt_reads in more than min_samples will be removed when no black list is given.
}
\details{
Filter a set of mutations using one of two options:

\describe{
\item{1.}{By providing a black list (recommended), which includes a vector of genomic loci chr_pos when substitution_specific is false,
   or chr_pos_ref_alt when substitutions_specific is true. In this mode, all mutations reported in the black list are simply removed.}

\item{2.}{By providing a set of bam files. The function will run a similar functionality to \code{\link{create_background_panel}} and filter
   mutations based on the min_alt_reads and min_samples criteria.}
}

This function is called internally in \code{\link{test_ctDNA}} so you likely won't need to use it yourself.
}
\examples{
data("mutations", package = "ctDNAtools")
filter_mutations(mutations, black_list = "chr14_106327474_C_G")
}
\seealso{
\code{\link{create_black_list}} \code{\link{test_ctDNA}} \code{\link{create_background_panel}}
}
