% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicaltrials_gov_dates.R
\name{clinicaltrials_gov_dates}
\alias{clinicaltrials_gov_dates}
\title{Download a table of dates on which a ClinicalTrials.gov registry
entry was updated}
\usage{
clinicaltrials_gov_dates(nctids, status_change_only = FALSE, quiet = TRUE)
}
\arguments{
\item{nctids}{A list of well-formed NCT numbers,
e.g. c("NCT00942747", "NCT03281616"). (A capitalized "NCT"
followed by eight numerals with no spaces or hyphens.)}

\item{status_change_only}{If TRUE, returns only the dates marked
with a Recruitment Status change, default FALSE.}

\item{quiet}{A boolean TRUE or FALSE. If TRUE, no messages will be
printed during download. TRUE by default, messages printed for
every registry entry downloaded showing progress.}
}
\value{
A table with three columns: the version number (starting
from 0), the ISO-8601 formatted date on which there were
clinical trial history version updates, and the trial's overall
status on that date.
}
\description{
Download a table of dates on which a ClinicalTrials.gov registry
entry was updated
}
\examples{

\donttest{
versions <- clinicaltrials_gov_dates("NCT00942747")
}

}
