% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbFindIdsUniqueTrials}
\alias{dbFindIdsUniqueTrials}
\title{Deduplicate records to provide unique clinical trial identifiers}
\usage{
dbFindIdsUniqueTrials(preferregister = "EUCTR",
  prefermemberstate = "GB", include3rdcountrytrials = TRUE,
  collection = "ctrdata", db = "users", url = "mongodb://localhost",
  username = "", password = "", verbose = TRUE)
}
\arguments{
\item{preferregister}{The abbreviation of the preferred register, in case
a trial is in more than one register (string, either "EUCTR" or "CTGOV").
If set to an empty string (""), keeps the keys for the same trial in both
registers in the returned vector.}

\item{prefermemberstate}{Code of single EU Member State for which records should
returned. If not available, a record for GB or lacking this, any other record
for the trial will be returned. For a list of codes of EU
Member States, please see vector \code{countriesEUCTR}. Alternatively, "3RD"
will lead to return the Third Country record of a trial, if available.}

\item{include3rdcountrytrials}{A logical value if trials should be retained
that are conducted *exclusively* in third countries, that is outside the European Union.}

\item{collection}{Name of collection (default is "ctrdata")}

\item{db}{Name of database (default is "users")}

\item{url}{Address of the mongodb server in mongo connection string URI format
\url{http://docs.mongodb.org/manual/reference/connection-string/} (default is
mongodb://localhost)}

\item{username}{In case access requires credentials.}

\item{password}{In case access requires credentials.}

\item{verbose}{If set to \code{TRUE}, prints out information about numbers
of records found at subsequent steps when searching for duplicates}
}
\value{
A vector with strings of keys ("_id" in the database) that
  represent non-duplicate trials.
}
\description{
If records for a clinical trial are found from more than one register, the
record from EUCTR is returned. The function currently relies on CTGOV
recording other identifiers such as the EudraCT number in the field "Other
IDs".
}
\examples{

\dontrun{
dbFindIdsUniqueTrials()
}

}
